/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzesDashboardAction.java 151 2012-10-10 09:03:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzesDashboardAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import static org.nuiton.i18n.I18n._;

import java.text.ParseException;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.AnalyzeFilter;
import com.herbocailleau.sgq.business.model.AnalyzeModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

/**
 * Action d'affichage des analyses en attente de preparation et celle
 * à recevoir.
 * Gere egalement la validation du formulaire (envoi des preparations).
 * 
 * @author echatellier
 */
public class AnalyzesDashboardAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected ReferentialService referentialService;

    protected BatchService batchService;

    protected List<AnalyzeModel> analysisToSend;

    protected List<BatchAnalyze> analysisToReceive;

    protected String analyzeTypeId;

    protected String supplier;

    protected String sentDateBegin;

    protected String sentDateEnd;

    protected int batchNumberBegin;

    protected int batchNumberEnd;

    protected AnalyzeType analyzeType;

    protected List<AnalyzeType> analyzeTypes;

    protected List<Supplier> suppliers;

    /** Validation du formulaire : liste des analyses selectionées. */
    protected List<String> analyzeIds;

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getSentDateBegin() {
        return sentDateBegin;
    }

    public void setSentDateBegin(String sentDateBegin) {
        this.sentDateBegin = sentDateBegin;
    }

    public String getSentDateEnd() {
        return sentDateEnd;
    }

    public void setSentDateEnd(String sentDateEnd) {
        this.sentDateEnd = sentDateEnd;
    }

    public int getBatchNumberBegin() {
        return batchNumberBegin;
    }

    public void setBatchNumberBegin(int batchNumberBegin) {
        this.batchNumberBegin = batchNumberBegin;
    }

    public int getBatchNumberEnd() {
        return batchNumberEnd;
    }

    public void setBatchNumberEnd(int batchNumberEnd) {
        this.batchNumberEnd = batchNumberEnd;
    }

    @Override
    public void prepare() throws Exception {
        referentialService = newService(ReferentialService.class);
        batchService = newService(BatchService.class);
    }

    protected void loadData() {
        // le reste sert seulement s'il y a une erreur lors de la validation
        // et que l'on revient au mode input
        analyzeTypes = referentialService.findAllAnalyzeTypes();
        suppliers = referentialService.getAllSupplierOnlyLabs();

        if (StringUtils.isNotEmpty(analyzeTypeId)) {
            analyzeType = referentialService.findAnalyzeTypeById(analyzeTypeId);
        }

        AnalyzeFilter filter = new AnalyzeFilter();
        filter.setAnalyzeType(analyzeType);
        filter.setBatchNumberBegin(batchNumberBegin);
        filter.setBatchNumberEnd(batchNumberEnd);
        if (StringUtils.isNotBlank(sentDateBegin)) {
            try {
                filter.setSentDateBegin(SgqUtils.parseSgqDate(sentDateBegin));
            } catch (ParseException ex) {
                addActionError("Date invalide (dd/mm/yyyy) : " + sentDateBegin);
            }
        }
        if (StringUtils.isNotBlank(sentDateEnd)) {
            try {
                filter.setSentDateEnd(SgqUtils.parseSgqDate(sentDateEnd));
            } catch (ParseException ex) {
                addActionError("Date invalide (dd/mm/yyyy) : " + sentDateEnd);
            }
        }
        filter.setSupplier(supplier);

        BatchService batchService = newService(BatchService.class);
        analysisToSend = batchService.getAnalysisToSend(filter);
        analysisToReceive = batchService.getAnalysisToReceive(filter);
    }

    @Override
    public String input() throws Exception {
        loadData();
        return super.input();
    }

    public AnalyzeType getAnalyzeType() {
        return analyzeType;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }

    public List<Supplier> getSuppliers() {
        return suppliers;
    }

    public List<AnalyzeModel> getAnalysisToSend() {
        return analysisToSend;
    }

    public List<BatchAnalyze> getAnalysisToReceive() {
        return analysisToReceive;
    }

    public Date getNow() {
        return new Date();
    }

    public void setAnalyzeIds(List<String> analyzeIds) {
        this.analyzeIds = analyzeIds;
    }

    @Override
    public void validate() {
        if (analyzeIds != null) {
            for (String analyzeId : analyzeIds) {
                BatchAnalyze analyze = batchService.getAnalyzeById(analyzeId);

                String check = getParameter("check." + analyze.getTopiaId());
                if ("true".equalsIgnoreCase(check)) {
                    String supplierId = getParameter("supplier." + analyze.getTopiaId());
                    Supplier supplier = referentialService.getSupplierById(supplierId);
                    
                    if (supplier == null) {
                        addActionError(_("Prestataire manquant pour l'analyse %s du lot %d",
                                analyze.getAnalyzeType().getName(), analyze.getBatch().getNumber()));
                    }
                    
                    String sentDate = getParameter("sentDate." + analyze.getTopiaId());
                    try {
                        SgqUtils.parseSgqDate(sentDate);
                    } catch (ParseException ex) {
                        addActionError(_("Date d'envoi invalide pour l'analyse %s du lot %d",
                                analyze.getAnalyzeType().getName(), analyze.getBatch().getNumber()));
                    }
                    
                    String receiveDate = getParameter("receiveDate." + analyze.getTopiaId());
                    try {
                        SgqUtils.parseSgqDate(receiveDate);
                    } catch (ParseException ex) {
                        addActionError(_("Date de réception invalide pour l'analyse %s du lot %d",
                                analyze.getAnalyzeType().getName(), analyze.getBatch().getNumber()));
                    }
                }
            }
        }

        if (hasErrors()) {
            loadData();
        }
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "analyzes-dashboard!input"})})
    public String execute() throws Exception {
        String result = SUCCESS;
        if (analyzeIds != null) {
            for (String analyzeId : analyzeIds) {
                BatchAnalyze analyze = batchService.getAnalyzeById(analyzeId);

                String supplierId = getParameter("supplier." + analyze.getTopiaId());
                Supplier supplier = referentialService.getSupplierById(supplierId);

                Date sentDate = null;
                Date receiveDate = null;
                // il est possible de valider le formulaire pour sauvegarder
                // les informations sur le fournisseur sans pour autant
                // envoyer l'echantillon
                String check = getParameter("check." + analyze.getTopiaId());
                if ("true".equalsIgnoreCase(check)) {
                    String sDate = getParameter("sentDate." + analyze.getTopiaId());
                    String rDate = getParameter("receiveDate." + analyze.getTopiaId());
                    sentDate = SgqUtils.parseSgqDate(sDate); // can't fail here
                    receiveDate = SgqUtils.parseSgqDate(rDate); // can't fail here
                }

                batchService.sendAnalyzeToSupplier(analyze, sentDate, receiveDate, supplier);
            }
        } else {
            result = input();
        }

        return result;
    }
}
