/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzeTypesAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/AnalyzeTypesAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class AnalyzeTypesAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6915148559808770928L;

    protected List<AnalyzeType> analyzeTypes;

    @Override
    public String execute() throws Exception {
        
        ReferentialService referentialService = newService(ReferentialService.class);
        analyzeTypes = referentialService.findAllAnalyzeTypes();

        return SUCCESS;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }
}
