<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<%@ taglib uri="http://www.opensymphony.com/sitemesh/decorator" prefix="decorator" %> 
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
       <link rel="stylesheet" type="text/css" href="<s:url value='/css/sgq.css' />" />
       <link rel="stylesheet" type="text/css" href="<s:url value='/css/sgq-print.css' />" media="print" />
       <title>SGQ : <decorator:title default="Système de gestion de la qualit&eacute;"/></title>
       <script type="text/javascript" src="<s:url value='/ext/jquery/js/jquery.js' />"></script>
       <script type="text/javascript" src="<s:url value='/js/sgq.js' />"></script>
       <decorator:head/>
    </head>
    <body>

        <div id="sgq-header">
            <div class="logo">
                <a href="<s:url action='index' namespace='/' />">
                    <img src="<s:url value='/img/logo.gif'/>" />
                 </a>
            </div>
            
            <span class="application">SGQ</span>
            
            <div class="infos">
	            <div class="userinfo">
                    <img class="print" src="<s:url value='/img/printer_off.png' />"
                        title="Imprimer" onclick="window.print();" /> -
	            	admin - Administrateur -
	            	<a href="<s:url action='login' namespace='/' />">D&eacute;connexion</a>
	            </div>
	            <div class="search">
	                <form action="<s:url action='search' namespace='/user' />" method="get">
	                    <input type="text" name="search.query" />
	                    <input type="submit" value="Rechercher" />
	                </form>
	            </div>
            </div>
        </div>

        <div id="sgq-body">   
	        <div id="sgq-menu">
	           <ul>
                   <li><a href="<s:url action='search' namespace='/user' />">Consultation des donn&eacute;es</a></li>
               </ul>
               <ul>
	               <li><a href="<s:url action='batch-import!input' namespace='/user' />">R&eacute;ception des lots</a></li>
                   <li><a href="<s:url action='analyzes' namespace='/user' />">Pr&eacute;paration d'analyses</a></li>
	               <li><a href="<s:url action='analyzes-dashboard!input' namespace='/user' />">Gestion des analyses</a></li>
	               <li><a href="<s:url action='labels!input' namespace='/user' />">Gestion &eacute;tiquettes</a></li>
	               <li><a href="<s:url action='places' namespace='/user' />">Emplacements</a></li>
	               <li><a href="<s:url action='inventory' namespace='/user' />">Inventaire</a></li>
               </ul>
               <ul>
	               <li>R&eacute;f&eacute;rentiels:
	                   <ul>
	                       <li><a href="<s:url action='products' namespace='/admin' />">R&eacute;f&eacute;rentiel produit</a></li>
	                       <li><a href="<s:url action='clients!input' namespace='/admin' />">R&eacute;f&eacute;rentiel client</a></li>
	                       <li><a href="<s:url action='suppliers' namespace='/admin' />">R&eacute;f&eacute;rentiel fournisseur</a></li>
	                       <li><a href="<s:url action='places!input' namespace='/admin' />">R&eacute;f&eacute;rentiel emplacement</a></li>
	                   </ul>
	               </li>
               </ul>
               <ul>
	               <li>Administration:
	               		<ul>
	               			<li><a href="<s:url action='analyze-types' namespace='/admin' />">Types d'analyses</a></li>
	               			<li><a href="<s:url action='users' namespace='/admin' />">Gestion des utilisateurs</a></li>
	               		</ul>
	               </li>
	           </ul>
	        </div>
	        
	        <div id="sgq-content">
	            <decorator:body/>
	        </div>
        </div>

        <div id="sgq-footer">
           <ul>
            <li><a href="http://forge.codelutin.com/projects/sgq-ch">Cailleau - SGQ</a></li>
            <li><a href="http://forge.codelutin.com/projects/sgq-ch/roadmap?completed=1">
            	<s:property value='applicationVersion' />
           	</a></li>
            <li><a href="mailto:sgq-ch-devel@list.forge.codelutin.com">Contact</a></li>
            <li>Copyright 2012 <a href="http://www.herbo-cailleau.com/">Herboristerie Cailleau</a>,
            	Tous droits r&eacute;serv&eacute;s</li>
           </ul> 
        </div>
    </body>
</html>
