<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Gestion des analyzes</title>
    </head>
    <body>
        <h1>Gestion des analyses</h1>

		<fieldset>
			<legend>Filtre</legend>
            <form action="<s:url action='analyzes-dashboard!input' namespace='/user' />">
            <table>
                <tr>
                    <td>Type d'analyse : </td>
                    <td><select name="analyzeTypeId">
                       <option />
                       <s:iterator value="analyzeTypes" var="at">
                          <option value="<s:property value="topiaId" />"
                            <s:if test="#at == analyzeType">
                              selected="selected"
                            </s:if>
                          ><s:property value="name" /></option>
                       </s:iterator>
                    </select></td>
                </tr>
                <tr>
                    <td>Num&eacute;ro de lots :</td>
                    <td><input type="text" name="batchNumberBegin"
                       <s:if test="batchNumberBegin != 0">value="<s:property value="batchNumberBegin" />"</s:if> /> &agrave;
                    <input type="text" name="batchNumberEnd"
                       <s:if test="batchNumberEnd != 0">value="<s:property value="batchNumberEnd" />"</s:if> /></td>
                </tr>
                <tr>
                    <td>Fournisseur :</td>
                    <td><input type="text" name="supplier" value="<s:property value="supplier" />" /></td>
                </tr>
                <tr>
                    <td>Date d'envoi :</td>
                    <td><input type="text" name="sentDateBegin" value="<s:property value="sentDateBegin" />" /> &agrave;
                    <input type="text" name="sentDateEnd" value="<s:property value="sentDateEnd" />" /></td>
                </tr>
                <tr>
                    <td colspan="2"><input type="submit" value="Filtrer" /></td>
                </tr>
            </table>
            </form>
		</fieldset>

        <h3>Échantillon à préparer:</h3>
        
        <s:form action="analyzes-dashboard">
        
            <s:actionerror />

	        <table class="listing">
	            <tr>
	                <th>Lot</th>
	                <th>Plante</th>
	                <th>DPMES</th>
	                <th>Type d'analyse</th>
	                <th>Date limite d'envoi</th>
                    <th>Date d'envoi</th>
	                <th>Prestataire</th>
	                <th>Fait</th>
	            </tr>
                <s:iterator value="analysisToSend">
                    <tr>
                        <td><a href="<s:url action='batch' namespace='/user'>
                            <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                        </s:url>"><s:property value="batch.number" /></a></td>
                        <td><a href="<s:url action='batch' namespace='/user'>
                            <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                        </s:url>"><s:property value="batch.product.name" /></a></td>
                        <td><s:property value="batch.dpmes" /></td>
                        <td><s:property value="analyzeType.name" /></td>
                        <td></td>
                        <td><input type="text" name="sentDate.<s:property value="topiaId" />" value="<s:text name="sgq.web.common.dateformat">
                          <s:param value="now"/>
                        </s:text>" size="10"/></td>
                        <td>
                            <select name="supplier.<s:property value="topiaId" />">
                            <option></option>
                            <optgroup label="Laboratoires">
                            <s:iterator value="suppliers">
                                <option value="<s:property value="topiaId" />"><s:property value="name" /></option>
                            </s:iterator>
                            </optgroup>

                            <optgroup label="Fournisseurs">
                                <option value="<s:property value="batch.supplier.topiaId" />"><s:property value="batch.supplier.name" /></option>
                            </optgroup>
                            </select>
                        </td>
                        <td><input type="checkbox" name="analyzeIds" value="<s:property value="topiaId" />" /></td>
                    </tr>
                </s:iterator>
	        </table>
	        <input type="submit" value="Valider l'envoi" />
        </s:form>

        <h3>Analyses en attente:</h3>

        <table class="listing">
            <tr>
                <th>Lot</th>
                <th>Plante</th>
                <th>DPMES</th>
                <th>Type d'analyse</th>
                <th>Envoyé le</th>
                <th>Prestataire</th>
                <th>Analyse reçue</th>
            </tr>
            <s:iterator value="analysisToReceive">
                <tr>
                    <td><a href="<s:url action='batch' namespace='/user'>
                        <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                    </s:url>"><s:property value="batch.number" /></a></td>
                    <td><a href="<s:url action='batch' namespace='/user'>
                        <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                    </s:url>"><s:property value="batch.product.name" /></a></td>
                    <td><s:property value="batch.dpmes" /></td>
                    <td><s:property value="analyzeType.name" /></td>
                    <td><s:text name="sgq.web.common.dateformat">
                        <s:param value="sentDate"/>
                      </s:text></td>
                    <td>
                        <s:property value="supplier.name" />
                    </td>
                    <td>
                        <a href="<s:url action='analyzes-receipt!input' namespace='/user'>
                            <s:param name="analyzeId"><s:property value="topiaId" /></s:param>
                        </s:url>">
                            Valider la réception
                        </a>
                    </td>
                </tr>
            </s:iterator>
        </table>
    </body>
</html>
