/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchImportAction
extends SgqActionSupport {
    private static final long serialVersionUID = 3074255662512738956L;
    private static final Log log = LogFactory.getLog(BatchImportAction.class);
    protected long batchsCount;
    protected int nextNonBioBatchNumber;
    protected int nextBioBatchNumber;
    protected File file;
    protected List<ImportLog<Batch>> importLogs;

    public String input() throws Exception {
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        this.batchsCount = batchService.getBatchCount();
        this.nextNonBioBatchNumber = batchService.getNextNonBioBatchNumber();
        this.nextBioBatchNumber = batchService.getNextBioBatchNumber();
        return super.input();
    }

    public long getBatchsCount() {
        return this.batchsCount;
    }

    public int getNextNonBioBatchNumber() {
        return this.nextNonBioBatchNumber;
    }

    public int getNextBioBatchNumber() {
        return this.nextBioBatchNumber;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String execute() throws Exception {
        String result = super.execute();
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        try {
            this.importLogs = batchService.importBatchFile(this.file);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import batch file", (Throwable)ex);
            }
            this.addActionError(ex.getMessage());
            result = this.input();
        }
        return result;
    }

    public List<ImportLog<Batch>> getImportLogs() {
        return this.importLogs;
    }
}

