/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlacesAction
extends SgqActionSupport {
    private static final long serialVersionUID = 7464265806217949750L;
    private static final Log log = LogFactory.getLog(PlacesAction.class);
    protected List<Place> places;
    protected File file;
    protected List<ImportLog<Place>> importLogs;

    public String input() throws Exception {
        ReferentialService referentialService = (ReferentialService)this.newService(ReferentialService.class);
        this.places = referentialService.getPlaces();
        return super.input();
    }

    public List<Place> getPlaces() {
        return this.places;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String execute() throws Exception {
        String result = super.execute();
        ReferentialService referentialService = (ReferentialService)this.newService(ReferentialService.class);
        try {
            this.importLogs = referentialService.importPlaces(this.file);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import places file", (Throwable)ex);
            }
            this.addActionError(ex.getMessage());
            result = this.input();
        }
        return result;
    }

    public List<ImportLog<Place>> getImportLogs() {
        return this.importLogs;
    }
}

