/*
 * #%L
 * SGQ :: Web
 * $Id: ClientAction.java 75 2012-09-19 13:45:04Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ClientAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

public class ClientAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4820174489319218088L;

    protected ReferentialService referentialService;

    protected String clientId;

    protected Client client;

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public void prepare() throws Exception {
        referentialService = newService(ReferentialService.class);
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName" , "clients"})})
    public String execute() throws Exception {

        referentialService.saveClient(client);

        return super.execute();
    }
    
    public Client getClient() {
        if (client == null) {
            String clientId = getParameter("clientId");
            if (StringUtils.isNotBlank(clientId)) {
                client = referentialService.findClientById(clientId);
            } else {
                client = new ClientImpl();
            }
        }
        return client;
    }
}
