/*
 * #%L
 * SGQ :: Web
 * $Id: IndexAction.java 40 2012-09-03 15:00:59Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/IndexAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class IndexAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2484601181596627492L;

    protected long batchsCount;

    protected long productsCount;

    protected long clientsCount;

    protected long suppliersCount;

    protected long placesCount;

    @Override
    public String execute() throws Exception {

        BatchService batchService = newService(BatchService.class);
        batchsCount = batchService.getBatchCount();
        
        ReferentialService referentialService = newService(ReferentialService.class);
        productsCount = referentialService.getProductsCount();
        clientsCount = referentialService.getClientsCount();
        suppliersCount = referentialService.getSuppliersCount();
        placesCount = referentialService.getPlacesCount();
        return SUCCESS;
    }
    
    public long getBatchsCount() {
        return batchsCount;
    }

    public long getProductsCount() {
        return productsCount;
    }

    public long getClientsCount() {
        return clientsCount;
    }

    public long getSuppliersCount() {
        return suppliersCount;
    }

    public long getPlacesCount() {
        return placesCount;
    }
}
