<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title><s:text name="sgq.web.batch.title" /></title>
    </head>
    <body>
        <h1><s:text name="sgq.web.batch.title" /></h1>

        <h2><s:text name="sgq.web.batch.batchdesc">
              <s:param value="batch.number"/>
              <s:param value="batch.product.code"/>
              <s:param value="batch.product.name"/>
            </s:text></h2>
        
        <h3>Informations</h3>
        <ul>
            <li><s:text name="sgq.web.batch.entrydate">
              <s:param value="batch.entryDate"/>
            </s:text></li>
            <s:if test="batch.dmes == null">
				<li><s:text name="sgq.web.batch.dmesnull"/></li>
            </s:if>
            <s:else>
				<li><s:text name="sgq.web.batch.dmes">
	              <s:param value="batch.dmes"/>
	            </s:text></li>
           	</s:else>
            <li><s:text name="sgq.web.batch.dpmes">
	              <s:param value="batch.dpmes"/>
	            </s:text> (<a href="javascript:window.prompt('Nouvelle DPMES');location.reload()">modifier</a>)</li>
            <li><s:text name="sgq.web.batch.dpmesf">
                  <s:param value="batch.dpmesf"/>
                </s:text> (<a href="javascript:window.prompt('Nouvelle DPMESF');location.reload()">modifier</a>)</li>
            <li><s:text name="sgq.web.batch.dluo">
	              <s:param value="batch.dluo"/>
	            </s:text></li>
            <li><s:text name="sgq.web.batch.supplier">
	              <s:param value="batch.supplier.code"/>
	            </s:text></li>
            <li>Client dédié : <s:property value="batch.client.name" /></li>
            <li>Statut : <s:property value="batch.product.status" /></li>
            <li>Quantité entrée : <s:property value="batch.quantity" /> ???</li>
        </ul>
        
        <h3>Présentations</h3>
        <table class="listing">
            <tr>
                <th>Type</th>
                <th>Désignation</th>
                <th>Quantité</th>
            </tr>

            <s:iterator value="presentations">
            	<tr>
                    <td title="<s:property value="presentationCode.description" />"><s:property value="presentationCode.code" /></td>
	                <td><a href="<s:url action='batch-presentation-edit' namespace='/user'>
	                	<s:param name="presentationId"><s:property value="topiaId" /></s:param>
	                </s:url>"><s:property value="name" /></a></td>
	                <td><s:property value="quantity" /> <s:property value="unit" />???</td>
	            </tr>
            </s:iterator>
        </table>

        <h3>Analyses</h3>

        <table class="listing analysis">
            <tr>
                <th>Mention</th>
                <th>Type</th>
                <th>Date de reception</th>
            </tr>
            <s:iterator value="analyzes" var="analyze">
            	<tr>
                    <s:if test='#analyze.synthesisMention.name() == "CORRECT"'>
                      <td class="correct">Correcte</td>
                    </s:if>
                    <s:elseif test='#analyze.synthesisMention.name() == "FAIR"'>
                      <td class="fair">Passable</td>
                    </s:elseif>
                    <s:elseif test='#analyze.synthesisMention.name() == "NOT_ACCEPTABLE"'>
                      <td class="notAcceptable">Non acceptable</td>
                    </s:elseif>
                    <s:elseif test="#analyze.sentDate == null">
                      <td class="toSend">Echantillon à preparer</td>
                    </s:elseif>
                    <s:elseif test="#analyze.receiptDate == null">
                      <td class="toReceive">Attente réception fournisseur</td>
                    </s:elseif>
                    <s:else>
                      <td>bug</td>
                    </s:else>
	                <td><a href="<s:url action='batch-analyze' namespace='/user'>
                         <s:param name="analyzeId"><s:property value="topiaId" /></s:param>
                       </s:url>"><s:property value="analyzeType.name" /></a></td>
	                <td>
                      <s:if test="#analyze.receiptDate == null">
                        N/A
                      </s:if>
                      <s:else>
                      <s:text name="sgq.web.common.dateformat">
                        <s:param value="receiptDate"/>
                      </s:text>
                      </s:else></td>
	            </tr>
            </s:iterator>
        </table>

		<p><a href="<s:url action='batch-analyze-edit' namespace='/user'>
                <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
              </s:url>">Préparer une nouvelle analyse pour ce lot</a></p>

        <h3>Divers</h3>
        
        <ul>
            <s:if test="product.botanicControl"><li><a href="<s:url action='batch-control' namespace='/user'>
                <s:param name="batchid"><s:property value="batch.topiaId" /></s:param>
            </s:url>" target="_blank">Voir le PDF de contr&ocirc;le botanique</a></li></s:if>
                <s:elseif test="product.identificationControl"><li><a href="<s:url action='batch-control' namespace='/user'>
                <s:param name="batchid"><s:property value="batch.topiaId" /></s:param>
            </s:url>" target="_blank">Voir le PDF de controle d'identification</a></li></s:elseif>
        	<li><a href="<s:url action='batch-spent' namespace='/user'>
        		<s:param name="batchid"><s:property value="batch.topiaId" /></s:param>
        	</s:url>">Déclarer le lot épuisé</a></li>
        </ul>

    </body>
</html>
