/*
 * #%L
 * SGQ :: Web
 * $Id: SearchAction.java 53 2012-09-11 16:11:13Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/SearchAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class SearchAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    protected SearchModel search;

    protected List<BatchModel> batches;

    @Override
    public String execute() throws Exception {
        
        BatchService batchService = newService(BatchService.class);
        batches = batchService.searchBatch(getSearch());
        return SUCCESS;
    }

    public SearchModel getSearch() {
        if (search == null) {
            search = new SearchModel();
        }
        return search;
    }

    public List<BatchModel> getBatches() {
        return batches;
    }
}
