/*
 * #%L
 * SGQ :: Web
 * $Id: BatchAnalyzeEditProcessAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchAnalyzeEditProcessAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.Date;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.AnalyzeImpl;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de detail d'un lot.
 * Comprenant detail du lot, analyses et presentation.
 * 
 * @author echatellier
 */
public class BatchAnalyzeEditProcessAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String analyzeTypeId;

    protected String batchId;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getBatchId() {
        return batchId;
    }

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "batch", "batchId", "${batchId}"})})
    public String execute() throws Exception {
        
        BatchService batchService = newService(BatchService.class);
        Batch batch = batchService.getBatchById(batchId);
        ReferentialService referentialService = newService(ReferentialService.class);
        AnalyzeType analyzeType = referentialService.findAnalyzeTypeById(analyzeTypeId);
        
        Analyze analyze = new AnalyzeImpl();
        analyze.setBatch(batch);
        analyze.setAnalyzeType(analyzeType);
        analyze.setCreationDate(new Date());

        batchService.addAnalyze(analyze);

        return SUCCESS;
    }
}
