/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzesDashboardAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzesDashboardAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de detail d'un lot.
 * Comprenant detail du lot, analyses et presentation.
 * 
 * @author echatellier
 */
public class AnalyzesDashboardAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected List<Analyze> analysisToSend;

    protected List<Analyze> analysisToReceive;

    protected String analyzeTypeId;

    protected AnalyzeType analyzeType;

    protected List<AnalyzeType> analyzeTypes;

    protected List<Supplier> suppliers;

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }

    @Override
    public String execute() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        analyzeTypes = referentialService.findAllAnalyzeTypes();
        suppliers = referentialService.getAllSupplierLabFirst();

        if (StringUtils.isNotEmpty(analyzeTypeId)) {
            analyzeType = referentialService.findAnalyzeTypeById(analyzeTypeId);
        }

        BatchService batchService = newService(BatchService.class);
        analysisToSend = batchService.getAnalysisToSend(analyzeType);
        analysisToReceive = batchService.getAnalysisToReceive(analyzeType);
        return SUCCESS;
    }

    public AnalyzeType getAnalyzeType() {
        return analyzeType;
    }

    public void setAnalyzeType(AnalyzeType analyzeType) {
        this.analyzeType = analyzeType;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }

    public List<Supplier> getSuppliers() {
        return suppliers;
    }

    public List<Analyze> getAnalysisToSend() {
        return analysisToSend;
    }

    public List<Analyze> getAnalysisToReceive() {
        return analysisToReceive;
    }
}
