/*
 * #%L
 * SGQ :: Web
 * $Id: PlacesImportAction.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/PlacesImportAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.io.File;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class PlacesImportAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4863563937062659598L;

    protected File file;

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName" , "places"})})
    public String execute() throws Exception {
        ReferentialService referentialService = newService(ReferentialService.class);
        referentialService.importPlaces(file);
        return SUCCESS;
    }
}
