package com.herbocailleau.sgq.entities;

/*
 * #%L
 * SGQ :: Business
 * $Id: AnalyzeCategoryDAOImpl.java 347 2013-04-30 10:02:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-business/src/main/java/com/herbocailleau/sgq/entities/AnalyzeCategoryDAOImpl.java $
 * %%
 * Copyright (C) 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.nuiton.topia.TopiaException;

public class AnalyzeCategoryDAOImpl<E extends AnalyzeCategory> extends AnalyzeCategoryDAOAbstract<E> {

    /**
     * Retourne les categories ordonnés par nom with entity count that use each category.
     * 
     * @return status and count
     * @throws TopiaException 
     */
    public Map<E, Long> findAllWithUsageCount() throws TopiaException {
        String query = "SELECT C, " +
                " (select count(*) from " + AnalyzeType.class.getName() + " T" +
                "  where C = T." + AnalyzeType.PROPERTY_ANALYZE_CATEGORY + ")" +
                " from " + AnalyzeCategory.class.getName() + " C" +
                " order by " + AnalyzeCategory.PROPERTY_NAME;

        List<Object[]> results = (List<Object[]>)context.findAll(query);
        Map<E, Long> categories = new LinkedHashMap<E, Long>();
        for (Object[] result : results) {
            categories.put((E)result[0], ((Number)result[1]).longValue());
        }

        return categories;
    }
} //AnalyzeCategoryDAOImpl
