/*
 * #%L
 * SGQ :: Business
 * $Id: SupplierImportModel.java 245 2013-01-14 14:39:27Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/SupplierImportModel.java $
 * %%
 * Copyright (C) 2012 - 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import java.text.ParseException;

import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SupplierImpl;

/**
 * Modèle d'import du fichier CSV des fournisseurs;
 * 
 * "CODF_F";"FOUR_F";"PREST_F"
 * 
 * @author echatellier
 */
public class SupplierImportModel extends AbstractImportModel<Supplier> {

    public SupplierImportModel() {
        super(';');
        newMandatoryColumn("CODF_F", Supplier.PROPERTY_CODE);
        newMandatoryColumn("FOUR_F", Supplier.PROPERTY_NAME, new ValueParser<String>() {
            @Override
            public String parse(String value) throws ParseException {
                return value.trim();
            }
        });
        newMandatoryColumn("PREST_F", Supplier.PROPERTY_LABORATORY, new ValueParser<Boolean>() {
            @Override
            public Boolean parse(String value) throws ParseException {
                Boolean result = Boolean.FALSE;
                if ("Laboratoire".equalsIgnoreCase(value)) {
                    result = Boolean.TRUE;
                }
                return result;
            }
        });
    }

    @Override
    public Supplier newEmptyInstance() {
        return new SupplierImpl();
    }
}
