/*
 * #%L
 * SGQ :: Business
 * $Id: ServiceFactory.java 394 2013-06-19 08:44:58Z echatellier $
 * $HeadURL: https://svn.codelutin.com/sgq-ch/tags/sgq-ch-1.1.5/sgq-business/src/main/java/com/herbocailleau/sgq/business/ServiceFactory.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaUtil;
import org.nuiton.topia.migration.TopiaMigrationEngine;
import org.nuiton.topia.migration.TopiaMigrationService;

import com.herbocailleau.sgq.SGQDAOHelper;
import com.herbocailleau.sgq.business.migration.DatabaseMigration;
import com.herbocailleau.sgq.entities.BatchImpl;

/**
 * Factory des services.
 * 
 * @author echatellier
 */
public class ServiceFactory {

    private static final Log log = LogFactory.getLog(ServiceFactory.class);

    protected static TopiaContext rootContext;

    protected static SgqBusinessConfig config;

    public static SgqBusinessConfig getConfig() {
        if (config == null) {
            config = new SgqBusinessConfig();
            config.parse();
        }
        return config;
    }

    public static TopiaContext getRootContext() {

        if (rootContext == null) {
            SgqBusinessConfig config = getConfig();
            Properties props = config.getFlatOptions();

            props.setProperty(TopiaContextFactory.CONFIG_PERSISTENCE_CLASSES,
                    SGQDAOHelper.getImplementationClassesAsString());

            // add migration service
            props.setProperty(TopiaMigrationService.TOPIA_SERVICE_NAME, TopiaMigrationEngine.class.getName());
            props.setProperty(TopiaMigrationService.MIGRATION_CALLBACK, DatabaseMigration.class.getName());

            try {
                rootContext = TopiaContextFactory.getContext(props);
                initSchema(rootContext);
            } catch (TopiaException ex) {
                throw new RuntimeException("Can't init root context", ex);
            }
        }

        return rootContext;
    }

    protected static void initSchema(TopiaContext rootContext) throws TopiaException {
        TopiaContext transaction = rootContext.beginTransaction();
        boolean testBatch = TopiaUtil.isSchemaExist(transaction, BatchImpl.class.getName());
        transaction.closeContext();
        if (!testBatch) {
            if (log.isInfoEnabled()) {
                log.info("Create database schema");
            }
            rootContext.createSchema();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Table batch found, skip schema creation");
            }
        }
    }

    public static <E extends SgqService> E newService(Class<E> serviceClass, TopiaContext transaction) {
        E service = null;

        try {
            service = serviceClass.newInstance();
        } catch (InstantiationException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        } catch (IllegalAccessException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        }
        ServiceDAOHelper daoHelper = new ServiceDAOHelper(transaction);
        service.setServiceDAOHelper(daoHelper);
        service.setConfig(getConfig());

        return service;
    }
}
