/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business;

import com.herbocailleau.sgq.business.SgqBusinessConfig;
import com.herbocailleau.sgq.entities.Product;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;

public class SgqUtils {
    protected static final DateFormat DF_DDMMYYY = new SimpleDateFormat("dd/MM/yyyy");
    protected static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#0.0##", new DecimalFormatSymbols(Locale.US));

    public static String getProductUnit(SgqBusinessConfig config, Product product) {
        String code = product.getCode();
        String result = null;
        if (code.charAt(0) == 'Z') {
            switch (code.charAt(1)) {
                case 'Y': {
                    result = I18n._((String)"000 Unit\u00e9s", (Object[])new Object[0]);
                    break;
                }
                case 'V': 
                case 'X': {
                    result = I18n._((String)"L", (Object[])new Object[0]);
                    break;
                }
                default: {
                    result = I18n._((String)"kg", (Object[])new Object[0]);
                    break;
                }
            }
        } else {
            result = I18n._((String)"kg", (Object[])new Object[0]);
        }
        return result;
    }

    public static Date parseSgqDate(String value) throws ParseException {
        return DF_DDMMYYY.parse(value);
    }

    public static boolean isSgqDate(String value) {
        return value != null && value.matches("\\d{1,2}/\\d{1,2}/\\d{4}");
    }

    public static String formatSgqDate(Date value) {
        return DF_DDMMYYY.format(value);
    }

    public static String getSHA1Hash(String ... values) {
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append(value);
        }
        return StringUtil.encodeSHA1((String)builder.toString());
    }

    public static String formatNumber(double number) {
        return DECIMAL_FORMAT.format(number);
    }

    public static long daysBetween(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        long diffDays = (date2ms - date1ms) / 86400000L;
        return diffDays;
    }
}

