/*
 * #%L
 * SGQ :: Business
 * $Id: PostgreSGQDialect.java 427 2013-07-26 12:58:24Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.2/sgq-business/src/main/java/com/herbocailleau/sgq/business/PostgreSGQDialect.java $
 * %%
 * Copyright (C) 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import java.util.List;

import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.type.Type;

/**
 * Definition d'un dialect personnalisé pour pouvoir utiliser la fonction cast() de postgres
 * sans que cela cause des erreurs hibernate.
 * 
 * @author Eric Chatellier
 */
public class PostgreSGQDialect extends PostgreSQLDialect {

    /**
     * Custom cast function.
     */
    protected void registerFunction(final String name, SQLFunction function) {
        if (name.equals("cast")) {
            super.registerFunction(name, new StandardSQLFunction("cast") {
                public String render(Type firstArgumentType, List arguments, SessionFactoryImplementor sessionFactory) {
                    StringBuffer buf = new StringBuffer();
                    buf.append( name ).append( '(' );
                    for ( int i = 0; i < arguments.size(); i++ ) {
                        buf.append( arguments.get( i ) );
                        if ( i < arguments.size() - 1 ) {
                            buf.append( " as " );
                        }
                    }
                    return buf.append( ')' ).toString();
                }
            });
        } else {
            super.registerFunction(name, function);
        }
    }
}
