/*
 * #%L
 * SGQ :: Business
 * $Id: PlaceDAOImpl.java 394 2013-06-19 08:44:58Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-business/src/main/java/com/herbocailleau/sgq/entities/PlaceDAOImpl.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */
package com.herbocailleau.sgq.entities;

import java.util.List;

import org.nuiton.topia.TopiaException;

/**
 * Operations specifiques au emplacements.
 * 
 * @author echatellier
 */
public class PlaceDAOImpl<E extends Place> extends PlaceDAOAbstract<E> {

    /**
     * Delete all Place entities.
     * 
     * @throws TopiaException
     */
    public void deleteAll() throws TopiaException {
        String query = "delete from " + Place.class.getName();
        context.execute(query);
    }

    /**
     * Renvoie les emplacements pour une zone.
     * 
     * @param zone zone (can be null)
     * @throws TopiaException 
     */
    public List<Place> findAllForZone(Zone zone) throws TopiaException {
        String query = "from " + Place.class.getName();

        if (zone != null) {
            query += " WHERE " + Place.PROPERTY_ZONE + " = :zone";
        }
        
        query += " ORDER BY " + Place.PROPERTY_ZONE + " ASC, " + Place.PROPERTY_CODE + " ASC";
        
        List<Place> result;
        if (zone != null) {
            result = context.findAll(query, "zone", zone);
        } else {
            result = context.findAll(query);
        }
        return result;
    }

    /**
     * Retourne le nombre de presentation inventorié à un emplacement.
     * 
     * @return
     * @throws TopiaException
     */
    public long getProductInventoredIntoPlace(Place place) throws TopiaException {
        String query = "SELECT count(*) from " + Presentation.class.getName() +
                " where :place in elements(" + Presentation.PROPERTY_INVENTORY_PLACES + ")";
        
        Number result = (Number)context.findUnique(query, "place", place);
        return result.longValue();
    }

} //PlaceDAOImpl<E extends Place>
