/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.business.model.AnalyzeFilter;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.BatchAnalyzeDAOAbstract;
import com.herbocailleau.sgq.entities.BatchDAO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;

public class BatchAnalyzeDAOImpl<E extends BatchAnalyze>
extends BatchAnalyzeDAOAbstract<E> {
    public List<BatchAnalyze> findAllAnalyzeToSend(AnalyzeFilter analyzeFilter) throws TopiaException {
        String query = "from " + BatchAnalyze.class.getName() + " where " + "sentDate" + " is null";
        return this.findAllAnalyzeWithQuery(analyzeFilter, query);
    }

    public List<BatchAnalyze> findAllAnalyzeToReceive(AnalyzeFilter analyzeFilter) throws TopiaException {
        String query = "from " + BatchAnalyze.class.getName() + " where " + "receiptDate" + " is null" + " and " + "sentDate" + " is not null";
        return this.findAllAnalyzeWithQuery(analyzeFilter, query);
    }

    public List<BatchAnalyze> findAllAnalyze(AnalyzeFilter analyzeFilter) throws TopiaException {
        String query = "from " + BatchAnalyze.class.getName() + " where 1=1";
        return this.findAllAnalyzeWithQuery(analyzeFilter, query);
    }

    protected List<BatchAnalyze> findAllAnalyzeWithQuery(AnalyzeFilter analyzeFilter, String queryPrefix) throws TopiaException {
        String query = queryPrefix;
        ArrayList<Object> params = new ArrayList<Object>();
        if (analyzeFilter.getAnalyzeType() != null) {
            query = query + " and analyzeType = :analyzeType";
            params.add("analyzeType");
            params.add(analyzeFilter.getAnalyzeType());
        }
        if (analyzeFilter.getBatchNumberBegin() > 0) {
            query = query + " and :batchNumberBegin <= batch.number";
            params.add("batchNumberBegin");
            params.add(analyzeFilter.getBatchNumberBegin());
        }
        if (analyzeFilter.getBatchNumberEnd() > 0) {
            query = query + " and batch.number <= :batchNumberEnd";
            params.add("batchNumberEnd");
            params.add(analyzeFilter.getBatchNumberEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)analyzeFilter.getSupplier())) {
            query = query + " and " + BatchDAO.getFieldLikeInsensitive("supplier.name", ":supplier");
            params.add("supplier");
            params.add("%" + StringUtils.stripAccents((String)analyzeFilter.getSupplier()) + "%");
        }
        if (analyzeFilter.getSentDateBegin() != null) {
            query = query + " and :datebegin <= dateadd('day', -analyzeType.durationDays, batch.dpmes)";
            params.add("datebegin");
            params.add(analyzeFilter.getSentDateBegin());
        }
        if (analyzeFilter.getSentDateEnd() != null) {
            query = query + " and dateadd('day', -analyzeType.durationDays, batch.dpmes) <= :dateend";
            params.add("dateend");
            params.add(analyzeFilter.getSentDateEnd());
        }
        query = query + " order by batch.dpmes";
        query = query + " , batch.number";
        query = query + " , topiaId";
        List result = this.context.findAll(query, params.toArray());
        return result;
    }
}

