/*
 * #%L
 * SGQ :: Business
 * $Id: SupplierDAOImpl.java 76 2012-09-19 14:09:14Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.0/sgq-business/src/main/java/com/herbocailleau/sgq/entities/SupplierDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.util.List;

import org.nuiton.topia.TopiaException;

public class SupplierDAOImpl<E extends Supplier> extends SupplierDAOAbstract<E> {

    /**
     * Retourne seulement les fournisseurs de type laboratoire ordonnés par
     * nom.
     * 
     * @return les fournisseurs laboratoire
     * @throws TopiaException 
     */
    public List<Supplier> findAllOnlyLabs() throws TopiaException {
        String query = "from " + Supplier.class.getName() +
            " where " + Supplier.PROPERTY_LABORATORY + " = true" +
            " order by " + Supplier.PROPERTY_NAME + " ASC";

        return context.findAll(query);
    }
}
