package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class PlaceAbstract extends TopiaEntityAbstract implements Place {

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : product
     */
    protected ProductPlace productProductPlace;

    /**
     * Nom de l'attribut en BD : zone
     */
    protected Zone zone;

    private static final long serialVersionUID = 3978476380288857652L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_PRODUCT_PRODUCT_PLACE, ProductPlace.class, productProductPlace);
        visitor.visit(this, PROPERTY_ZONE, Zone.class, zone);
        visitor.end(this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        fireOnPreWrite(PROPERTY_CODE, oldValue, code);
        this.code = code;
        fireOnPostWrite(PROPERTY_CODE, oldValue, code);
    }

    @Override
    public String getCode() {
        fireOnPreRead(PROPERTY_CODE, code);
        String result = this.code;
        fireOnPostRead(PROPERTY_CODE, code);
        return result;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setZone(Zone zone) {
        Zone oldValue = this.zone;
        fireOnPreWrite(PROPERTY_ZONE, oldValue, zone);
        this.zone = zone;
        fireOnPostWrite(PROPERTY_ZONE, oldValue, zone);
    }

    @Override
    public Zone getZone() {
        fireOnPreRead(PROPERTY_ZONE, zone);
        Zone result = this.zone;
        fireOnPostRead(PROPERTY_ZONE, zone);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        if (this.productProductPlace != null) {
            tmp.add(this.productProductPlace);
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //PlaceAbstract
