package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class BatchDAOAbstract<E extends Batch> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Batch.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Batch;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<BatchAnalyze> list = getContext()
                                                    .getDAO(BatchAnalyze.class)
                                                    .findAllByProperties(BatchAnalyze.PROPERTY_BATCH, entity);
                                            for (BatchAnalyze item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getBatch())) {
                                                    item.setBatch(null);
                                                }
                        
                    }
                }

                                        {
                                        List<Presentation> list = getContext()
                                                    .getDAO(Presentation.class)
                                                    .findAllByProperties(Presentation.PROPERTY_BATCH, entity);
                                            for (Presentation item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getBatch())) {
                                                    item.setBatch(null);
                                                }
                        
                    }
                }

                                        {
                                        List<AnalyzeFile> list = getContext()
                                                    .getDAO(AnalyzeFile.class)
                                                    .findAllByProperties(AnalyzeFile.PROPERTY_BATCH, entity);
                                            for (AnalyzeFile item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getBatch())) {
                                                    item.setBatch(null);
                                                }
                        
                    }
                }

                                        {
                                        List<LabelError> list = getContext()
                                                    .getDAO(LabelError.class)
                                                    .findAllByProperties(LabelError.PROPERTY_AFTER_BATCH_EXPIRATION, entity);
                                            for (LabelError item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getAfterBatchExpiration())) {
                                                    item.setAfterBatchExpiration(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByNaturalId(int number) throws TopiaException {
        return findByProperties(Batch.PROPERTY_NUMBER, number);
    }

    public boolean existByNaturalId(int number) throws TopiaException {
        return existByProperties(Batch.PROPERTY_NUMBER, number);
    }

    /**
     * @deprecated since 2.6.10, prefer use {@link #createByNaturalId}
     * @param number 
     * @return 
     * @throws TopiaException
     */
    @Deprecated
    public E create(int number) throws TopiaException {
        return create(Batch.PROPERTY_NUMBER, number);
    }

    public E createByNaturalId(int number) throws TopiaException {
        return create(Batch.PROPERTY_NUMBER, number);
    }

    public E createByNotNull(int number) throws TopiaException {
        return create(Batch.PROPERTY_NUMBER, number);
    }

    public E findByNumber(int v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_NUMBER, v);
        return result;
    }

    public List<E> findAllByNumber(int v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_NUMBER, v);
        return result;
    }

    public E findByOrderNumber(long v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_ORDER_NUMBER, v);
        return result;
    }

    public List<E> findAllByOrderNumber(long v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_ORDER_NUMBER, v);
        return result;
    }

    public E findByEntryDate(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_ENTRY_DATE, v);
        return result;
    }

    public List<E> findAllByEntryDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_ENTRY_DATE, v);
        return result;
    }

    public E findByDmes(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_DMES, v);
        return result;
    }

    public List<E> findAllByDmes(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_DMES, v);
        return result;
    }

    public E findByDmesd(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_DMESD, v);
        return result;
    }

    public List<E> findAllByDmesd(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_DMESD, v);
        return result;
    }

    public E findByDpmes(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_DPMES, v);
        return result;
    }

    public List<E> findAllByDpmes(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_DPMES, v);
        return result;
    }

    public E findByDluo(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_DLUO, v);
        return result;
    }

    public List<E> findAllByDluo(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_DLUO, v);
        return result;
    }

    public E findByExpiredDate(Date v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_EXPIRED_DATE, v);
        return result;
    }

    public List<E> findAllByExpiredDate(Date v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_EXPIRED_DATE, v);
        return result;
    }

    public E findByQuantity(double v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_QUANTITY, v);
        return result;
    }

    public List<E> findAllByQuantity(double v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_QUANTITY, v);
        return result;
    }

    public E findByPackageCount(int v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_PACKAGE_COUNT, v);
        return result;
    }

    public List<E> findAllByPackageCount(int v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_PACKAGE_COUNT, v);
        return result;
    }

    public E findBySampleCode(String v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_SAMPLE_CODE, v);
        return result;
    }

    public List<E> findAllBySampleCode(String v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_SAMPLE_CODE, v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_COMMENT, v);
        return result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_COMMENT, v);
        return result;
    }

    public E findByImportHash(String v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_IMPORT_HASH, v);
        return result;
    }

    public List<E> findAllByImportHash(String v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_IMPORT_HASH, v);
        return result;
    }

    public E findByInvalid(boolean v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_INVALID, v);
        return result;
    }

    public List<E> findAllByInvalid(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_INVALID, v);
        return result;
    }

    public E findBySupplier(Supplier v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_SUPPLIER, v);
        return result;
    }

    public List<E> findAllBySupplier(Supplier v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_SUPPLIER, v);
        return result;
    }

    public E findByProduct(Product v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_PRODUCT, v);
        return result;
    }

    public List<E> findAllByProduct(Product v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_PRODUCT, v);
        return result;
    }

    public E findByDedicatedClient(Client v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_DEDICATED_CLIENT, v);
        return result;
    }

    public List<E> findAllByDedicatedClient(Client v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_DEDICATED_CLIENT, v);
        return result;
    }

    public E findByOrigin(Country v) throws TopiaException {
        E result = findByProperty(Batch.PROPERTY_ORIGIN, v);
        return result;
    }

    public List<E> findAllByOrigin(Country v) throws TopiaException {
        List<E> result = findAllByProperty(Batch.PROPERTY_ORIGIN, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == LabelError.class) {
            LabelErrorDAO dao = (LabelErrorDAO)
                getContext().getDAO(LabelError.class);
            tmp = dao.findAllByAfterBatchExpiration(entity);
            result.addAll(tmp);
        }

        if (type == AnalyzeFile.class) {
            AnalyzeFileDAO dao = (AnalyzeFileDAO)
                getContext().getDAO(AnalyzeFile.class);
            tmp = dao.findAllByBatch(entity);
            result.addAll(tmp);
        }

        if (type == Presentation.class) {
            PresentationDAO dao = (PresentationDAO)
                getContext().getDAO(Presentation.class);
            tmp = dao.findAllByBatch(entity);
            result.addAll(tmp);
        }

        if (type == BatchAnalyze.class) {
            BatchAnalyzeDAO dao = (BatchAnalyzeDAO)
                getContext().getDAO(BatchAnalyze.class);
            tmp = dao.findAllByBatch(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(4);

        List<? extends TopiaEntity> list;

        list = findUsages(LabelError.class, entity);
        if (!list.isEmpty()) {
            result.put(LabelError.class, list);
        }

        list = findUsages(AnalyzeFile.class, entity);
        if (!list.isEmpty()) {
            result.put(AnalyzeFile.class, list);
        }

        list = findUsages(Presentation.class, entity);
        if (!list.isEmpty()) {
            result.put(Presentation.class, list);
        }

        list = findUsages(BatchAnalyze.class, entity);
        if (!list.isEmpty()) {
            result.put(BatchAnalyze.class, list);
        }

        return result;
    }

} //BatchDAOAbstract<E extends Batch>
