/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services.csv;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.services.csv.InventoryBean;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.PresentationCode;
import java.text.ParseException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

public class InventoryImportModel
extends AbstractImportModel<InventoryBean> {
    public InventoryImportModel(final Map<Integer, Batch> batchCache) {
        super(';');
        this.newIgnoredColumn("Zone");
        this.newIgnoredColumn("Emplacement");
        this.newMandatoryColumn("Code pr\u00e9sentation", "presentationCode", (ValueParser)new ValueParser<PresentationCode>(){

            public PresentationCode parse(String value) throws ParseException {
                PresentationCode result = null;
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    result = PresentationCode.getPresentationCodeFor(value.trim().charAt(0));
                }
                return result;
            }
        });
        this.newIgnoredColumn("Code produit");
        this.newIgnoredColumn("Nom produit");
        this.newMandatoryColumn("Lot", "batch", (ValueParser)new ValueParser<Batch>(){

            public Batch parse(String value) throws ParseException {
                Integer number;
                Batch result = null;
                if (StringUtils.isNotBlank((CharSequence)value) && (result = (Batch)batchCache.get(number = Integer.valueOf(value.trim()))) == null) {
                    throw new SgqBusinessException(I18n._((String)"Impossible de trouver le lot %s", (Object[])new Object[]{value}));
                }
                return result;
            }
        });
        this.newIgnoredColumn("DLUO");
        this.newIgnoredColumn("Quantit\u00e9");
        this.newMandatoryColumn("Valeur relev\u00e9e", "realQuantity", (ValueParser)new ValueParser<Double>(){

            public Double parse(String value) throws ParseException {
                Double result = null;
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    result = Double.valueOf(value.trim());
                }
                return result;
            }
        });
    }

    public InventoryBean newEmptyInstance() {
        return new InventoryBean();
    }
}

