/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services.csv;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.csv.InventoryBean;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.Zone;
import java.util.Date;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;
import org.nuiton.util.csv.ModelBuilder;
import org.nuiton.util.csv.ValueFormatter;

public class InventoryExportModel
implements ExportModel<InventoryBean> {
    public char getSeparator() {
        return ';';
    }

    public Iterable<ExportableColumn<InventoryBean, Object>> getColumnsForExport() {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.newColumnForExport("Zone", "zone", (ValueFormatter)new ValueFormatter<Zone>(){

            public String format(Zone value) {
                String result = value.toString();
                return result;
            }
        });
        modelBuilder.newColumnForExport("Emplacement", "place", (ValueFormatter)new ValueFormatter<Place>(){

            public String format(Place value) {
                String result = value.getCode();
                return result;
            }
        });
        modelBuilder.newColumnForExport("Code pr\u00e9sentation", "presentationCode", (ValueFormatter)new ValueFormatter<PresentationCode>(){

            public String format(PresentationCode value) {
                String result = "";
                if (value != null) {
                    result = String.valueOf(value.getCode());
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Code produit", "product", (ValueFormatter)new ValueFormatter<Product>(){

            public String format(Product value) {
                String result = value.getCode();
                return result;
            }
        });
        modelBuilder.newColumnForExport("Nom produit", "product", (ValueFormatter)new ValueFormatter<Product>(){

            public String format(Product value) {
                return value.getName();
            }
        });
        modelBuilder.newColumnForExport("Lot", "batch", (ValueFormatter)new ValueFormatter<Batch>(){

            public String format(Batch value) {
                String result = "";
                if (value != null) {
                    result = String.valueOf(value.getNumber());
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("DLUO", "dluo", (ValueFormatter)new ValueFormatter<Date>(){

            public String format(Date value) {
                String result = "";
                if (value != null) {
                    result = SgqUtils.formatSgqDate(value);
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Quantit\u00e9", "quantity", (ValueFormatter)new ValueFormatter<Double>(){

            public String format(Double value) {
                String result = "";
                if (value != null) {
                    result = String.valueOf(value);
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Valeur relev\u00e9e", "realQuantity", (ValueFormatter)new ValueFormatter<Double>(){

            public String format(Double value) {
                return "";
            }
        });
        return modelBuilder.getColumnsForExport();
    }
}

