/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.model;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.BatchModelFunction;
import org.nuiton.i18n.I18n;

public enum SearchColumn {
    PRODUCT_CODE(I18n._((String)"Code Produit", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getCode();
        }
    }, true),
    PRODUCT_NAME(I18n._((String)"Nom Produit", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getName();
        }
    }, true),
    PRODUCT_LATIN_NAME(I18n._((String)"Nom latin", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getLatinName();
        }
    }, false),
    PRODUCT_CATEGORY(I18n._((String)"Cat\u00e9gorie", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            return batchModel.getBatch().getProduct().getCategory();
        }
    }, false),
    BATCH_NUMBER(I18n._((String)"Lot", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            return String.valueOf(batchModel.getBatch().getNumber());
        }
    }, true),
    BATCH_SUPPLIER(I18n._((String)"Fournisseur", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getSupplier() != null) {
                result = batchModel.getBatch().getSupplier().getName();
            }
            return result;
        }
    }, false),
    BATCH_CLIENT(I18n._((String)"Client", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDedicatedClient() != null) {
                result = batchModel.getBatch().getDedicatedClient().getName();
            }
            return result;
        }
    }, false),
    BATCH_ORIGIN(I18n._((String)"Origine", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getOrigin() != null) {
                result = batchModel.getBatch().getOrigin().getCountry();
            }
            return result;
        }
    }, false),
    BATCH_TOTAL_PRESENTATION(I18n._((String)"Quantit\u00e9 disponible", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            return String.valueOf(batchModel.getTotalPresentation());
        }
    }, true),
    BATCH_TOTAL_SALE(I18n._((String)"Cumul vente", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            return String.valueOf(batchModel.getTotalSale());
        }
    }, false),
    BATCH_ENTRY_DATE(I18n._((String)"Date d'entr\u00e9e", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getEntryDate() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getEntryDate());
            }
            return result;
        }
    }, false),
    BATCH_DPMES(I18n._((String)"DPMES", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDpmes() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getDpmes());
            }
            return result;
        }
    }, false),
    BATCHDMES(I18n._((String)"DMES", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getDmes() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getDmes());
            }
            return result;
        }
    }, false),
    BATCH_DMESD(I18n._((String)"DMESD", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDmesd() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getDmesd());
            }
            return result;
        }
    }, false),
    BATCH_DLUO(I18n._((String)"DLUO", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getDluo() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getDluo());
            }
            return result;
        }
    }, true),
    BATCH_EXPIRED_DATE(I18n._((String)"Date d'\u00e9puisement", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = null;
            if (batchModel.getBatch().getExpiredDate() != null) {
                result = SgqUtils.formatSgqDate(batchModel.getBatch().getExpiredDate());
            }
            return result;
        }
    }, false),
    BATCH_COMMENT(I18n._((String)"Commentaire", (Object[])new Object[0]), new BatchModelFunction(){

        @Override
        public String apply(BatchModel batchModel) {
            String result = batchModel.getBatch().getComment();
            return result;
        }
    }, false);

    protected String description;
    protected boolean defaultSelected;
    protected BatchModelFunction function;

    private SearchColumn(String description, BatchModelFunction function, boolean defaultSelected) {
        this.description = description;
        this.function = function;
        this.defaultSelected = defaultSelected;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefaultSelected() {
        return this.defaultSelected;
    }

    public String getValueFor(BatchModel batchModel) {
        return this.function.apply(batchModel);
    }
}

