/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business;

import com.herbocailleau.sgq.business.SgqBusinessConfig;
import com.herbocailleau.sgq.entities.Product;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nuiton.i18n.I18n;
import org.nuiton.util.StringUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SgqUtils {
    protected static final DateFormat DF_DDMMYYY = new SimpleDateFormat("dd/MM/yyyy");

    public static boolean isInternalClient(SgqBusinessConfig config, int clientId) {
        boolean result = false;
        result |= config.getClientInternalZc() == clientId;
        result |= config.getClientInternalZe() == clientId;
        return result |= config.getClientInternalZp() == clientId;
    }

    public static String getProductUnit(SgqBusinessConfig config, Product product) {
        String code = product.getCode();
        String result = null;
        if (code.charAt(0) == 'Z') {
            switch (code.charAt(1)) {
                case 'U': 
                case 'Y': {
                    result = I18n._((String)"000 Unit\u00e9s", (Object[])new Object[0]);
                    break;
                }
                case 'V': 
                case 'X': {
                    result = I18n._((String)"L", (Object[])new Object[0]);
                    break;
                }
                default: {
                    result = I18n._((String)"kg", (Object[])new Object[0]);
                    break;
                }
            }
        } else {
            result = I18n._((String)"kg", (Object[])new Object[0]);
        }
        return result;
    }

    public static Document parseDocument(String content) throws IOException {
        Document result = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = builder.parse(new InputSource(new StringReader(content)));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return result;
    }

    public static Date parseSgqDate(String value) throws ParseException {
        return DF_DDMMYYY.parse(value);
    }

    public static String formatSgqDate(Date value) {
        return DF_DDMMYYY.format(value);
    }

    public static String getSHA1Hash(String ... values) {
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append(value);
        }
        return StringUtil.encodeSHA1((String)builder.toString());
    }
}

