package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class ProductAbstract extends TopiaEntityAbstract implements Product {

    /**
     * Nom de l'attribut en BD : code
     */
    protected String code;

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : category
     */
    protected String category;

    /**
     * Nom de l'attribut en BD : latinName
     */
    protected String latinName;

    /**
     * Nom de l'attribut en BD : family
     */
    protected String family;

    /**
     * Nom de l'attribut en BD : botanicControl
     */
    protected boolean botanicControl;

    /**
     * Nom de l'attribut en BD : identificationControl
     */
    protected boolean identificationControl;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : productStatus
     */
    protected Collection<ProductStatus> productStatus;

    /**
     * Nom de l'attribut en BD : analyzeType
     */
    protected Collection<AnalyzeType> analyzeType;

    /**
     * Nom de l'attribut en BD : place
     */
    protected ProductPlace placeProductPlace;

    private static final long serialVersionUID = 3546919190825886769L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_CODE, String.class, code);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_CATEGORY, String.class, category);
        visitor.visit(this, PROPERTY_LATIN_NAME, String.class, latinName);
        visitor.visit(this, PROPERTY_FAMILY, String.class, family);
        visitor.visit(this, PROPERTY_BOTANIC_CONTROL, boolean.class, botanicControl);
        visitor.visit(this, PROPERTY_IDENTIFICATION_CONTROL, boolean.class, identificationControl);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_PRODUCT_STATUS, Collection.class, ProductStatus.class, productStatus);
        visitor.visit(this, PROPERTY_ANALYZE_TYPE, Collection.class, AnalyzeType.class, analyzeType);
        visitor.visit(this, PROPERTY_PLACE_PRODUCT_PLACE, ProductPlace.class, placeProductPlace);
        visitor.end(this);
    }

    @Override
    public void setCode(String code) {
        String oldValue = this.code;
        fireOnPreWrite(PROPERTY_CODE, oldValue, code);
        this.code = code;
        fireOnPostWrite(PROPERTY_CODE, oldValue, code);
    }

    @Override
    public String getCode() {
        fireOnPreRead(PROPERTY_CODE, code);
        String result = this.code;
        fireOnPostRead(PROPERTY_CODE, code);
        return result;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setCategory(String category) {
        String oldValue = this.category;
        fireOnPreWrite(PROPERTY_CATEGORY, oldValue, category);
        this.category = category;
        fireOnPostWrite(PROPERTY_CATEGORY, oldValue, category);
    }

    @Override
    public String getCategory() {
        fireOnPreRead(PROPERTY_CATEGORY, category);
        String result = this.category;
        fireOnPostRead(PROPERTY_CATEGORY, category);
        return result;
    }

    @Override
    public void setLatinName(String latinName) {
        String oldValue = this.latinName;
        fireOnPreWrite(PROPERTY_LATIN_NAME, oldValue, latinName);
        this.latinName = latinName;
        fireOnPostWrite(PROPERTY_LATIN_NAME, oldValue, latinName);
    }

    @Override
    public String getLatinName() {
        fireOnPreRead(PROPERTY_LATIN_NAME, latinName);
        String result = this.latinName;
        fireOnPostRead(PROPERTY_LATIN_NAME, latinName);
        return result;
    }

    @Override
    public void setFamily(String family) {
        String oldValue = this.family;
        fireOnPreWrite(PROPERTY_FAMILY, oldValue, family);
        this.family = family;
        fireOnPostWrite(PROPERTY_FAMILY, oldValue, family);
    }

    @Override
    public String getFamily() {
        fireOnPreRead(PROPERTY_FAMILY, family);
        String result = this.family;
        fireOnPostRead(PROPERTY_FAMILY, family);
        return result;
    }

    @Override
    public void setBotanicControl(boolean botanicControl) {
        boolean oldValue = this.botanicControl;
        fireOnPreWrite(PROPERTY_BOTANIC_CONTROL, oldValue, botanicControl);
        this.botanicControl = botanicControl;
        fireOnPostWrite(PROPERTY_BOTANIC_CONTROL, oldValue, botanicControl);
    }

    @Override
    public boolean isBotanicControl() {
        fireOnPreRead(PROPERTY_BOTANIC_CONTROL, botanicControl);
        boolean result = this.botanicControl;
        fireOnPostRead(PROPERTY_BOTANIC_CONTROL, botanicControl);
        return result;
    }

    @Override
    public boolean getBotanicControl() {
        fireOnPreRead(PROPERTY_BOTANIC_CONTROL, botanicControl);
        boolean result = this.botanicControl;
        fireOnPostRead(PROPERTY_BOTANIC_CONTROL, botanicControl);
        return result;
    }

    @Override
    public void setIdentificationControl(boolean identificationControl) {
        boolean oldValue = this.identificationControl;
        fireOnPreWrite(PROPERTY_IDENTIFICATION_CONTROL, oldValue, identificationControl);
        this.identificationControl = identificationControl;
        fireOnPostWrite(PROPERTY_IDENTIFICATION_CONTROL, oldValue, identificationControl);
    }

    @Override
    public boolean isIdentificationControl() {
        fireOnPreRead(PROPERTY_IDENTIFICATION_CONTROL, identificationControl);
        boolean result = this.identificationControl;
        fireOnPostRead(PROPERTY_IDENTIFICATION_CONTROL, identificationControl);
        return result;
    }

    @Override
    public boolean getIdentificationControl() {
        fireOnPreRead(PROPERTY_IDENTIFICATION_CONTROL, identificationControl);
        boolean result = this.identificationControl;
        fireOnPostRead(PROPERTY_IDENTIFICATION_CONTROL, identificationControl);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public void addProductStatus(ProductStatus productStatus) {
        fireOnPreWrite(PROPERTY_PRODUCT_STATUS, null, productStatus);
        if (this.productStatus == null) {
            this.productStatus = new ArrayList<ProductStatus>();
        }

        this.productStatus.add(productStatus);
        fireOnPostWrite(PROPERTY_PRODUCT_STATUS, this.productStatus.size(), null, productStatus);
    }

    @Override
    public void addAllProductStatus(Collection<ProductStatus> productStatus) {
        if (productStatus == null) {
            return;
        }
        for (ProductStatus item : productStatus) {
            addProductStatus(item);
        }
    }

    @Override
    public void setProductStatus(Collection<ProductStatus> productStatus) {
        // Copy elements to keep data for fire with new reference
        Collection<ProductStatus> oldValue = this.productStatus != null ? new ArrayList<ProductStatus>(this.productStatus) : null;
        fireOnPreWrite(PROPERTY_PRODUCT_STATUS, oldValue, productStatus);
        this.productStatus = productStatus;
        fireOnPostWrite(PROPERTY_PRODUCT_STATUS, oldValue, productStatus);
    }

    @Override
    public void removeProductStatus(ProductStatus productStatus) {
        fireOnPreWrite(PROPERTY_PRODUCT_STATUS, productStatus, null);
        if (this.productStatus == null || !this.productStatus.remove(productStatus)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_PRODUCT_STATUS, this.productStatus.size() + 1, productStatus, null);
    }

    @Override
    public void clearProductStatus() {
        if (this.productStatus == null) {
            return;
        }
        Collection<ProductStatus> oldValue = new ArrayList<ProductStatus>(this.productStatus);
        fireOnPreWrite(PROPERTY_PRODUCT_STATUS, oldValue, this.productStatus);
        this.productStatus.clear();
        fireOnPostWrite(PROPERTY_PRODUCT_STATUS, oldValue, this.productStatus);
    }

    @Override
    public Collection<ProductStatus> getProductStatus() {
        return productStatus;
    }

    @Override
    public ProductStatus getProductStatusByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(productStatus, topiaId);
    }

    @Override
    public int sizeProductStatus() {
        if (productStatus == null) {
            return 0;
        }
        return productStatus.size();
    }

    @Override
    public boolean isProductStatusEmpty() {
        int size = sizeProductStatus();
        return size == 0;
    }

    @Override
    public void addAnalyzeType(AnalyzeType analyzeType) {
        fireOnPreWrite(PROPERTY_ANALYZE_TYPE, null, analyzeType);
        if (this.analyzeType == null) {
            this.analyzeType = new ArrayList<AnalyzeType>();
        }

        this.analyzeType.add(analyzeType);
        fireOnPostWrite(PROPERTY_ANALYZE_TYPE, this.analyzeType.size(), null, analyzeType);
    }

    @Override
    public void addAllAnalyzeType(Collection<AnalyzeType> analyzeType) {
        if (analyzeType == null) {
            return;
        }
        for (AnalyzeType item : analyzeType) {
            addAnalyzeType(item);
        }
    }

    @Override
    public void setAnalyzeType(Collection<AnalyzeType> analyzeType) {
        // Copy elements to keep data for fire with new reference
        Collection<AnalyzeType> oldValue = this.analyzeType != null ? new ArrayList<AnalyzeType>(this.analyzeType) : null;
        fireOnPreWrite(PROPERTY_ANALYZE_TYPE, oldValue, analyzeType);
        this.analyzeType = analyzeType;
        fireOnPostWrite(PROPERTY_ANALYZE_TYPE, oldValue, analyzeType);
    }

    @Override
    public void removeAnalyzeType(AnalyzeType analyzeType) {
        fireOnPreWrite(PROPERTY_ANALYZE_TYPE, analyzeType, null);
        if (this.analyzeType == null || !this.analyzeType.remove(analyzeType)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_ANALYZE_TYPE, this.analyzeType.size() + 1, analyzeType, null);
    }

    @Override
    public void clearAnalyzeType() {
        if (this.analyzeType == null) {
            return;
        }
        Collection<AnalyzeType> oldValue = new ArrayList<AnalyzeType>(this.analyzeType);
        fireOnPreWrite(PROPERTY_ANALYZE_TYPE, oldValue, this.analyzeType);
        this.analyzeType.clear();
        fireOnPostWrite(PROPERTY_ANALYZE_TYPE, oldValue, this.analyzeType);
    }

    @Override
    public Collection<AnalyzeType> getAnalyzeType() {
        return analyzeType;
    }

    @Override
    public AnalyzeType getAnalyzeTypeByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(analyzeType, topiaId);
    }

    @Override
    public int sizeAnalyzeType() {
        if (analyzeType == null) {
            return 0;
        }
        return analyzeType.size();
    }

    @Override
    public boolean isAnalyzeTypeEmpty() {
        int size = sizeAnalyzeType();
        return size == 0;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        if (this.placeProductPlace != null) {
            tmp.add(this.placeProductPlace);
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //ProductAbstract
