/*
 * #%L
 * SGQ :: Business
 * $Id: InventoryExportModel.java 155 2012-10-10 11:05:25Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/InventoryExportModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import static org.nuiton.i18n.I18n._;

import java.text.ParseException;
import java.util.Date;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;
import org.nuiton.util.csv.ModelBuilder;
import org.nuiton.util.csv.ValueFormatter;
import org.nuiton.util.csv.ValueParser;
import org.nuiton.util.csv.ext.AbstractImportModel;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.Zone;

/**
 * Zone, Emplacement, Code présentation, Code produit, Nom produit, Lot, DLUO, Quantité, Valeur relevée
 * 
 * @author echatellier
 */
public class InventoryExportModel implements ExportModel<InventoryBean> {

    @Override
    public char getSeparator() {
        return ';';
    }

    @Override
    public Iterable<ExportableColumn<InventoryBean, Object>> getColumnsForExport() {
        ModelBuilder<Batch> modelBuilder = new ModelBuilder<Batch>();
        modelBuilder.newColumnForExport("Zone", InventoryBean.PROPERTY_ZONE, new ValueFormatter<Zone>() {
            @Override
            public String format(Zone value) {
                String result = value.toString();
                return result;
            }
        });
        modelBuilder.newColumnForExport("Emplacement", InventoryBean.PROPERTY_PLACE, new ValueFormatter<Place>() {
            @Override
            public String format(Place value) {
                String result = value.getCode();
                return result;
            }
        });
        modelBuilder.newColumnForExport("Code présentation", InventoryBean.PROPERTY_PRESENTATION_CODE, new ValueFormatter<PresentationCode>() {
            @Override
            public String format(PresentationCode value) {
                String result = "";
                if (value != null) {
                    result = String.valueOf(value.getCode());
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Code produit", InventoryBean.PROPERTY_PRODUCT, new ValueFormatter<Product>() {
            @Override
            public String format(Product value) {
                String result = value.getCode();
                return result;
            }
        });
        modelBuilder.newColumnForExport("Nom produit", InventoryBean.PROPERTY_PRODUCT, new ValueFormatter<Product>() {
            @Override
            public String format(Product value) {
                return value.getName();
            }
        });
        modelBuilder.newColumnForExport("Lot", InventoryBean.PROPERTY_BATCH, new ValueFormatter<Batch>() {
            @Override
            public String format(Batch value) {
                String result = "";
                if (value != null) {
                    result = String.valueOf(value.getNumber());
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("DLUO", InventoryBean.PROPERTY_DLUO, new ValueFormatter<Date>() {
            @Override
            public String format(Date value) {
                String result = "";
                if (value != null) {
                    result = SgqUtils.formatSgqDate(value);
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Quantité", InventoryBean.PROPERTY_QUANTITY, new ValueFormatter<Double>() {
            @Override
            public String format(Double value) {
                String result = "";
                if (value != null) {
                    result = String.valueOf(value.doubleValue());
                }
                return result;
            }
        });
        modelBuilder.newColumnForExport("Valeur relevée", InventoryBean.PROPERTY_REAL_QUANTITY, new ValueFormatter<Double>() {
            @Override
            public String format(Double value) {
                return ""; // a remplir à l'import
            }
        });
        return (Iterable) modelBuilder.getColumnsForExport();
    }
}
