/*
 * #%L
 * SGQ :: Business
 * $Id: SgqBusinessConfig.java 148 2012-10-09 14:45:20Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-business/src/main/java/com/herbocailleau/sgq/business/SgqBusinessConfig.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import java.util.Properties;

import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;

/**
 * SGQ Business config.
 * 
 * @author echatellier
 */
public class SgqBusinessConfig {

    protected ApplicationConfig config;

    public SgqBusinessConfig() {
        config = new ApplicationConfig();
        for (SgqBusinessOption o : SgqBusinessOption.values()) {
            if (o.defaultValue != null) {
                config.setDefaultOption(o.key, o.defaultValue);
            }
        }
    }

    public void parse() {
        try {
            config.parse();
        } catch (ArgumentsParserException ex) {
            throw new SgqBusinessException("Can't load configuration", ex);
        }
    }

    public Properties getFlatOptions() {
        return config.getFlatOptions();
    }

    public int getBatchRangeNonBioStart() {
        return config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_NONBIO_START.key);
    }

    public int getBatchRangeNonBioEnd() {
        return config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_NONBIO_END.key);
    }

    public int getBatchRangeBioStart() {
        return config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_BIO_START.key);
    }

    public int getBatchRangeBioEnd() {
        return config.getOptionAsInt(SgqBusinessOption.BATCH_RANGE_BIO_END.key);
    }

    public String getLabelProductionFilename() {
        return config.getOption(SgqBusinessOption.LABEL_PRODUCTION_FILENAME.key);
    }

    public String getLabelExpeditionFilename() {
        return config.getOption(SgqBusinessOption.LABEL_EXPEDITION_FILENAME.key);
    }

    public int getClientInternalZc() {
        return config.getOptionAsInt(SgqBusinessOption.CLIENT_INTERNAL_ZC.key);
    }

    public int getClientInternalZe() {
        return config.getOptionAsInt(SgqBusinessOption.CLIENT_INTERNAL_ZE.key);
    }

    public int getClientInternalZp() {
        return config.getOptionAsInt(SgqBusinessOption.CLIENT_INTERNAL_ZP.key);
    }

    public String getImportCsvFileEncoding() {
        return config.getOption(SgqBusinessOption.IMPORT_CSV_FILE_ENCODING.key);
    }

    static enum SgqBusinessOption {

        CONFIG_FILE(ApplicationConfig.CONFIG_FILE_NAME, "sgqweb.properties"),
        SGQ_DIRECTORY("sgq.directory", "${java.io.tmpdir}/sgq"),
        HIBERNATE_DIALECT("hibernate.dialect", "org.hibernate.dialect.H2Dialect"),
        HIBERNATE_CONNECTION_URL("hibernate.connection.url", "jdbc:h2:file:${sgq.directory}/data/sgq"),
        HIBERNATE_CONNETION_USERNAME("hibernate.connection.username", "sa"),
        HIBERNATE_CONNECTION_PASSWORD("hibernate.connection.password", ""),

        IMPORT_CSV_FILE_ENCODING("import.csv.file.encoding", "UTF-8"),

        CLIENT_INTERNAL_ZC("client.internal.zc", "99997"),
        CLIENT_INTERNAL_ZE("client.internal.ze", "99998"),
        CLIENT_INTERNAL_ZP("client.internal.zp", "99999"),

        BATCH_RANGE_NONBIO_START("batch.range.nonbio.start", "21687"),
        BATCH_RANGE_NONBIO_END("batch.range.nonbio.end", "69999"),
        BATCH_RANGE_BIO_START("batch.range.bio.start", "71643"),
        BATCH_RANGE_BIO_END("batch.range.bio.end", "89999"),

        LABEL_PRODUCTION_FILENAME("label.production.filename", "FIF_HIST.txt"),
        LABEL_EXPEDITION_FILENAME("label.expedition.filename", "FIC_HIST.txt");

        protected String key;
        protected String defaultValue;

        private SgqBusinessOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }
    }
}
