/*
 * #%L
 * SGQ :: Business
 * $Id: ServiceDAOHelper.java 145 2012-10-09 12:44:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-business/src/main/java/com/herbocailleau/sgq/business/ServiceDAOHelper.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

import com.herbocailleau.sgq.SGQDAOHelper;
import com.herbocailleau.sgq.entities.AnalyzeCategoryDAO;
import com.herbocailleau.sgq.entities.AnalyzeFileDAO;
import com.herbocailleau.sgq.entities.AnalyzeTypeDAO;
import com.herbocailleau.sgq.entities.BatchAnalyzeDAO;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.ClientDAO;
import com.herbocailleau.sgq.entities.ExpeditionDAO;
import com.herbocailleau.sgq.entities.PlaceDAO;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.ProductDAO;
import com.herbocailleau.sgq.entities.ProductPlaceDAO;
import com.herbocailleau.sgq.entities.ProductStatusDAO;
import com.herbocailleau.sgq.entities.ProductionDAO;
import com.herbocailleau.sgq.entities.SupplierDAO;

/**
 * DAO helper instantiable contenant la transaction courante.
 * 
 * @author echatellier
 */
public class ServiceDAOHelper {

    protected TopiaContext transaction;

    public ServiceDAOHelper(TopiaContext transaction) {
        this.transaction = transaction;
    }

    public void commit() throws TopiaException {
        transaction.commitTransaction();
    }
    
    public void rollback() throws TopiaException {
        transaction.rollbackTransaction();
    }

    public BatchAnalyzeDAO getBatchAnalyzeDAO() throws TopiaException {
        return SGQDAOHelper.getBatchAnalyzeDAO(transaction);
    }

    public AnalyzeFileDAO getAnalyzeFileDAO() throws TopiaException {
        return SGQDAOHelper.getAnalyzeFileDAO(transaction);
    }

    public AnalyzeTypeDAO getAnalyzeTypeDAO() throws TopiaException {
        return SGQDAOHelper.getAnalyzeTypeDAO(transaction);
    }

    public BatchDAO getBatchDAO() throws TopiaException {
        return SGQDAOHelper.getBatchDAO(transaction);
    }

    public ClientDAO getClientDAO() throws TopiaException {
        return SGQDAOHelper.getClientDAO(transaction);
    }

    public PlaceDAO getPlaceDAO() throws TopiaException {
        return SGQDAOHelper.getPlaceDAO(transaction);
    }

    public PresentationDAO getPresentationDAO() throws TopiaException {
        return SGQDAOHelper.getPresentationDAO(transaction);
    }

    public ProductDAO getProductDAO() throws TopiaException {
        return SGQDAOHelper.getProductDAO(transaction);
    }

    public ExpeditionDAO getExpeditionDAO() throws TopiaException {
        return SGQDAOHelper.getExpeditionDAO(transaction);
    }

    public SupplierDAO getSupplierDAO() throws TopiaException {
        return SGQDAOHelper.getSupplierDAO(transaction);
    }
    
    public AnalyzeCategoryDAO getAnalyzeCategoryDAO() throws TopiaException {
        return SGQDAOHelper.getAnalyzeCategoryDAO(transaction);
    }

    public ProductStatusDAO getProductStatusDAO() throws TopiaException {
        return SGQDAOHelper.getProductStatusDAO(transaction);
    }

    public ProductPlaceDAO getProductPlaceDAO() throws TopiaException {
        return SGQDAOHelper.getProductPlaceDAO(transaction);
    }

    public ProductionDAO getProductionDAO() throws TopiaException {
        return SGQDAOHelper.getProductionDAO(transaction);
    }

} //ServiceDAOHelper
