/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.AnalyzeDAO;
import com.herbocailleau.sgq.entities.AnalyzeFile;
import com.herbocailleau.sgq.entities.AnalyzeFileDAO;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.Country;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.Supplier;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class BatchDAOAbstract<E extends Batch>
extends TopiaDAOImpl<E> {
    public Class<E> getEntityClass() {
        return Batch.class;
    }

    public SGQDAOHelper.SGQEntityEnum getTopiaEntityEnum() {
        return SGQDAOHelper.SGQEntityEnum.Batch;
    }

    public void delete(E entity) throws TopiaException {
        List list = this.getContext().getDAO(Analyze.class).findAllByProperties("batch", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getBatch())) continue;
            item.setBatch(null);
        }
        list = this.getContext().getDAO(Presentation.class).findAllByProperties("batch", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getBatch())) continue;
            item.setBatch(null);
        }
        list = this.getContext().getDAO(AnalyzeFile.class).findAllByProperties("batch", entity, new Object[0]);
        for (Object item : list) {
            if (!entity.equals(item.getBatch())) continue;
            item.setBatch(null);
        }
        super.delete(entity);
    }

    public E findByNaturalId(int number) throws TopiaException {
        return (E)((Batch)this.findByProperties("number", number, new Object[0]));
    }

    public boolean existByNaturalId(int number) throws TopiaException {
        return this.existByProperties("number", number, new Object[0]);
    }

    @Deprecated
    public E create(int number) throws TopiaException {
        return (E)((Batch)this.create(new Object[]{"number", number}));
    }

    public E createByNaturalId(int number) throws TopiaException {
        return (E)((Batch)this.create(new Object[]{"number", number}));
    }

    public E createByNotNull(int number) throws TopiaException {
        return (E)((Batch)this.create(new Object[]{"number", number}));
    }

    public E findByNumber(int v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("number", v);
        return (E)result;
    }

    public List<E> findAllByNumber(int v) throws TopiaException {
        List result = this.findAllByProperty("number", v);
        return result;
    }

    public E findByOrderNumber(long v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("orderNumber", v);
        return (E)result;
    }

    public List<E> findAllByOrderNumber(long v) throws TopiaException {
        List result = this.findAllByProperty("orderNumber", v);
        return result;
    }

    public E findByEntryDate(Date v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("entryDate", v);
        return (E)result;
    }

    public List<E> findAllByEntryDate(Date v) throws TopiaException {
        List result = this.findAllByProperty("entryDate", v);
        return result;
    }

    public E findByDmesd(Date v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("dmesd", v);
        return (E)result;
    }

    public List<E> findAllByDmesd(Date v) throws TopiaException {
        List result = this.findAllByProperty("dmesd", v);
        return result;
    }

    public E findByDpmes(Date v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("dpmes", v);
        return (E)result;
    }

    public List<E> findAllByDpmes(Date v) throws TopiaException {
        List result = this.findAllByProperty("dpmes", v);
        return result;
    }

    public E findByDluo(Date v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("dluo", v);
        return (E)result;
    }

    public List<E> findAllByDluo(Date v) throws TopiaException {
        List result = this.findAllByProperty("dluo", v);
        return result;
    }

    public E findByElapsedDate(Date v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("elapsedDate", v);
        return (E)result;
    }

    public List<E> findAllByElapsedDate(Date v) throws TopiaException {
        List result = this.findAllByProperty("elapsedDate", v);
        return result;
    }

    public E findByQuantity(double v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("quantity", v);
        return (E)result;
    }

    public List<E> findAllByQuantity(double v) throws TopiaException {
        List result = this.findAllByProperty("quantity", v);
        return result;
    }

    public E findByPackageCount(int v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("packageCount", v);
        return (E)result;
    }

    public List<E> findAllByPackageCount(int v) throws TopiaException {
        List result = this.findAllByProperty("packageCount", v);
        return result;
    }

    public E findBySampleCode(String v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("sampleCode", v);
        return (E)result;
    }

    public List<E> findAllBySampleCode(String v) throws TopiaException {
        List result = this.findAllByProperty("sampleCode", v);
        return result;
    }

    public E findByComment(String v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("comment", v);
        return (E)result;
    }

    public List<E> findAllByComment(String v) throws TopiaException {
        List result = this.findAllByProperty("comment", v);
        return result;
    }

    public E findByImportHash(String v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("importHash", v);
        return (E)result;
    }

    public List<E> findAllByImportHash(String v) throws TopiaException {
        List result = this.findAllByProperty("importHash", v);
        return result;
    }

    public E findByInvalid(boolean v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("invalid", v);
        return (E)result;
    }

    public List<E> findAllByInvalid(boolean v) throws TopiaException {
        List result = this.findAllByProperty("invalid", v);
        return result;
    }

    public E findBySupplier(Supplier v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("supplier", v);
        return (E)result;
    }

    public List<E> findAllBySupplier(Supplier v) throws TopiaException {
        List result = this.findAllByProperty("supplier", v);
        return result;
    }

    public E findByProduct(Product v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("product", v);
        return (E)result;
    }

    public List<E> findAllByProduct(Product v) throws TopiaException {
        List result = this.findAllByProperty("product", v);
        return result;
    }

    public E findByDedicatedClient(Client v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("dedicatedClient", v);
        return (E)result;
    }

    public List<E> findAllByDedicatedClient(Client v) throws TopiaException {
        List result = this.findAllByProperty("dedicatedClient", v);
        return result;
    }

    public E findByOrigin(Country v) throws TopiaException {
        Batch result = (Batch)this.findByProperty("origin", v);
        return (E)result;
    }

    public List<E> findAllByOrigin(Country v) throws TopiaException {
        List result = this.findAllByProperty("origin", v);
        return result;
    }

    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List tmp;
        TopiaDAOImpl dao;
        ArrayList result = new ArrayList();
        if (type == Presentation.class) {
            dao = (PresentationDAO)this.getContext().getDAO(Presentation.class);
            tmp = dao.findAllByBatch((Batch)entity);
            result.addAll(tmp);
        }
        if (type == AnalyzeFile.class) {
            dao = (AnalyzeFileDAO)this.getContext().getDAO(AnalyzeFile.class);
            tmp = dao.findAllByBatch((Batch)entity);
            result.addAll(tmp);
        }
        if (type == Analyze.class) {
            dao = (AnalyzeDAO)this.getContext().getDAO(Analyze.class);
            tmp = dao.findAllByBatch((Batch)entity);
            result.addAll(tmp);
        }
        return result;
    }

    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);
        List<Object> list = this.findUsages(Presentation.class, entity);
        if (!list.isEmpty()) {
            result.put(Presentation.class, list);
        }
        if (!(list = this.findUsages(AnalyzeFile.class, entity)).isEmpty()) {
            result.put(AnalyzeFile.class, list);
        }
        if (!(list = this.findUsages(Analyze.class, entity)).isEmpty()) {
            result.put(Analyze.class, list);
        }
        return result;
    }
}

