/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.business.model.AnalyzeFilter;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.AnalyzeDAOAbstract;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;

public class AnalyzeDAOImpl<E extends Analyze>
extends AnalyzeDAOAbstract<E> {
    public List<Analyze> findAllAnalyzeToSend(AnalyzeFilter analyzeFilter) throws TopiaException {
        String query = "from " + Analyze.class.getName() + " where " + "sentDate" + " is null";
        return this.findAllAnalyzeWithQuery(analyzeFilter, query);
    }

    public List<Analyze> findAllAnalyzeToReceive(AnalyzeFilter analyzeFilter) throws TopiaException {
        String query = "from " + Analyze.class.getName() + " where " + "receiptDate" + " is null" + " and " + "sentDate" + " is not null";
        return this.findAllAnalyzeWithQuery(analyzeFilter, query);
    }

    protected List<Analyze> findAllAnalyzeWithQuery(AnalyzeFilter analyzeFilter, String queryPrefix) throws TopiaException {
        String query = queryPrefix;
        ArrayList<Object> params = new ArrayList<Object>();
        if (analyzeFilter.getAnalyzeType() != null) {
            query = query + " and analyzeType = :analyzeType";
            params.add("analyzeType");
            params.add(analyzeFilter.getAnalyzeType());
        }
        if (analyzeFilter.getBatchNumberBegin() > 0) {
            query = query + " and :batchNumberBegin <= batch.number";
            params.add("batchNumberBegin");
            params.add(analyzeFilter.getBatchNumberBegin());
        }
        if (analyzeFilter.getBatchNumberEnd() > 0) {
            query = query + " and batch.number <= :batchNumberEnd";
            params.add("batchNumberEnd");
            params.add(analyzeFilter.getBatchNumberEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)analyzeFilter.getSupplier())) {
            query = query + " and supplier.name LIKE :supplier";
            params.add("supplier");
            params.add("%" + analyzeFilter.getSupplier() + "%");
        }
        query = query + " order by batch.dpmes";
        List result = this.context.findAll(query, params.toArray());
        return result;
    }
}

