/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services.csv;

import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.services.csv.InventoryBean;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Presentation;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.ExportableColumn;
import org.nuiton.util.csv.ModelBuilder;
import org.nuiton.util.csv.ValueFormatter;

public class InventoryExportModel
implements ExportModel<InventoryBean> {
    public char getSeparator() {
        return ';';
    }

    public Iterable<ExportableColumn<InventoryBean, Object>> getColumnsForExport() {
        ModelBuilder modelBuilder = new ModelBuilder();
        modelBuilder.newColumnForExport("Zone", "place", (ValueFormatter)new ValueFormatter<Place>(){

            public String format(Place value) {
                String result = null;
                result = value != null ? value.getZone().toString() : "";
                return result;
            }
        });
        modelBuilder.newColumnForExport("Emplacement", "place", (ValueFormatter)new ValueFormatter<Place>(){

            public String format(Place value) {
                String result = null;
                result = value != null ? value.getCode() : "";
                return result;
            }
        });
        modelBuilder.newColumnForExport("Code produit", "presentation", (ValueFormatter)new ValueFormatter<Presentation>(){

            public String format(Presentation value) {
                String result = value.getPresentationCode().getCode() + value.getBatch().getProduct().getCode();
                return result;
            }
        });
        modelBuilder.newColumnForExport("Nom produit", "batch", (ValueFormatter)new ValueFormatter<Batch>(){

            public String format(Batch value) {
                return value.getProduct().getName();
            }
        });
        modelBuilder.newColumnForExport("Lot", "batch", (ValueFormatter)new ValueFormatter<Batch>(){

            public String format(Batch value) {
                return String.valueOf(value.getNumber());
            }
        });
        modelBuilder.newColumnForExport("Quantit\u00e9", "batchModel", (ValueFormatter)new ValueFormatter<BatchModel>(){

            public String format(BatchModel value) {
                return String.valueOf(value.getTotalPresentation());
            }
        });
        modelBuilder.newColumnForExport("Valeurs relev\u00e9es", "batchModel", (ValueFormatter)new ValueFormatter<BatchModel>(){

            public String format(BatchModel value) {
                return "";
            }
        });
        return modelBuilder.getColumnsForExport();
    }
}

