/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import au.com.bytecode.opencsv.CSVWriter;
import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.AnalyzeFilter;
import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.model.PresentationModel;
import com.herbocailleau.sgq.business.model.SearchColumn;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.business.services.csv.BatchImportModel;
import com.herbocailleau.sgq.business.services.csv.InventoryBean;
import com.herbocailleau.sgq.business.services.csv.InventoryExportModel;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.AnalyzeDAO;
import com.herbocailleau.sgq.entities.AnalyzeFile;
import com.herbocailleau.sgq.entities.AnalyzeFileDAO;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.BatchImpl;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientDAO;
import com.herbocailleau.sgq.entities.Country;
import com.herbocailleau.sgq.entities.Expedition;
import com.herbocailleau.sgq.entities.ExpeditionDAO;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductDAO;
import com.herbocailleau.sgq.entities.ProductPlace;
import com.herbocailleau.sgq.entities.ProductPlaceDAO;
import com.herbocailleau.sgq.entities.Production;
import com.herbocailleau.sgq.entities.ProductionDAO;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SupplierDAO;
import com.herbocailleau.sgq.entities.Zone;
import com.itextpdf.text.DocumentException;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nl.knaw.dans.common.dbflib.CorruptedTableException;
import nl.knaw.dans.common.dbflib.Record;
import nl.knaw.dans.common.dbflib.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.util.csv.AbstractImportErrorInfo;
import org.nuiton.util.csv.Export;
import org.nuiton.util.csv.ExportModel;
import org.nuiton.util.csv.Import2;
import org.nuiton.util.csv.ImportConf;
import org.nuiton.util.csv.ImportModel;
import org.nuiton.util.csv.ImportRow;
import org.w3c.dom.Document;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class BatchService
extends SgqService {
    private static final Log log = LogFactory.getLog(BatchService.class);

    public long getBatchCount() {
        long count = 0L;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            count = batchDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return count;
    }

    public Pair<List<BatchModel>, Long> searchBatch(SearchModel search, int offset, int count) {
        Pair result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            List<BatchModel> elements = batchDAO.findAllModel(search, offset, count);
            Long totalCount = batchDAO.findAllCount(search);
            result = Pair.of(elements, (Object)totalCount);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't search batches", ex);
        }
        return result;
    }

    public InputStream searchBatchASCsv(SearchModel search) {
        FileInputStream result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            List<BatchModel> elements = batchDAO.findAllModel(search, 0, -1);
            File file = File.createTempFile("search", ".csv");
            file.deleteOnExit();
            CSVWriter csvWriter = new CSVWriter((Writer)new FileWriter(file));
            ArrayList<String> headers = new ArrayList<String>();
            for (SearchColumn searchColumn : search.getSearchColumns()) {
                headers.add(searchColumn.getDescription());
            }
            csvWriter.writeNext(headers.toArray(new String[headers.size()]));
            for (BatchModel batchModel : elements) {
                ArrayList<String> data = new ArrayList<String>(headers.size());
                for (SearchColumn searchColumn : search.getSearchColumns()) {
                    String content = searchColumn.getValueFor(batchModel);
                    if (content == null) {
                        data.add("");
                        continue;
                    }
                    data.add(content);
                }
                csvWriter.writeNext(data.toArray(new String[data.size()]));
            }
            csvWriter.close();
            result = new FileInputStream(file);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't search batches", ex);
        }
        catch (IOException ex) {
            throw new SgqBusinessException("Can't output csv file", ex);
        }
        return result;
    }

    public List<Batch> findAllBetweenNumbers(int startNumber, int endNumber) {
        List<Batch> result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.findAllBetweenNumbers(startNumber, endNumber);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't search batches", ex);
        }
        return result;
    }

    public Batch getBatchById(String batchId) {
        Batch result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = (Batch)batchDAO.findByTopiaId(batchId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public BatchModel getBatchModelById(String batchId) {
        BatchModel result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.findModelByTopiaId(batchId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    protected Batch getBatchByNumber(int batchNumer) {
        Batch result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = (Batch)batchDAO.findByNumber(batchNumer);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by number", ex);
        }
        return result;
    }

    public void saveBatch(Batch batch) {
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            batch = (Batch)batchDAO.update(batch);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't save batch", ex);
        }
    }

    public List<PresentationModel> findAllPresentationsByBatch(Batch batch) {
        ArrayList<PresentationModel> result = null;
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            ProductPlaceDAO productPlaceDAO = this.daoHelper.getProductPlaceDAO();
            ExpeditionDAO expeditionDAO = this.daoHelper.getExpeditionDAO();
            ProductionDAO productionDAO = this.daoHelper.getProductionDAO();
            List<Presentation> presentations = presentationDAO.findAllByBatchOrderByPresentation(batch);
            result = new ArrayList<PresentationModel>(presentations.size());
            for (Presentation presentation : presentations) {
                Production production;
                PresentationModel model = new PresentationModel(presentation);
                List<ProductPlace> productPlacesZE = productPlaceDAO.findByPresentationAndZone(presentation, Zone.ZE);
                for (ProductPlace productPlaceZE : productPlacesZE) {
                    if (productPlaceZE.getPresentationCode() != null && productPlaceZE.getPresentationCode() != presentation.getPresentationCode()) continue;
                    model.addPlace(productPlaceZE.getPlace());
                }
                Expedition expedition = expeditionDAO.findSingleForPresentationAndZone(presentation, Zone.ZP);
                if (expedition != null || model.getPlaces().isEmpty()) {
                    List<ProductPlace> productPlacesZP = productPlaceDAO.findByPresentationAndZone(presentation, Zone.ZP);
                    for (ProductPlace productPlaceZP : productPlacesZP) {
                        if (productPlaceZP.getPresentationCode() != null && productPlaceZP.getPresentationCode() != presentation.getPresentationCode()) continue;
                        model.addPlace(productPlaceZP.getPlace());
                    }
                }
                if ((production = productionDAO.findSingleForPresentationAndZone(presentation, Zone.ZC)) != null || model.getPlaces().isEmpty()) {
                    List<ProductPlace> productPlacesZC = productPlaceDAO.findByPresentationAndZone(presentation, Zone.ZC);
                    for (ProductPlace productPlaceZC : productPlacesZC) {
                        if (productPlaceZC.getPresentationCode() != null && productPlaceZC.getPresentationCode() != presentation.getPresentationCode()) continue;
                        model.addPlace(productPlaceZC.getPlace());
                    }
                }
                result.add(model);
            }
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public Presentation getPresentationById(String presentationId) {
        Presentation result = null;
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            result = (Presentation)presentationDAO.findByTopiaId(presentationId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public void updatePresentation(Presentation presentation) {
        try {
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            presentationDAO.update(presentation);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't update", ex);
        }
    }

    public List<Analyze> findAllAnalyzesByBatch(Batch batch) {
        List<Analyze> analyzes = null;
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            analyzes = analyzeDAO.findAllByBatch(batch);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by batch", ex);
        }
        return analyzes;
    }

    public List<AnalyzeFile> findAllAnalyzeFilesByBatch(Batch batch) {
        List<AnalyzeFile> analyzeFiles = null;
        try {
            AnalyzeFileDAO analyzeFileDAO = this.daoHelper.getAnalyzeFileDAO();
            analyzeFiles = analyzeFileDAO.findAllByBatch(batch);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by batch", ex);
        }
        return analyzeFiles;
    }

    public List<AnalyzeFile> findAllAnalyzeFilesByAnalyze(Analyze analyze) {
        List<AnalyzeFile> analyzeFiles = null;
        try {
            AnalyzeFileDAO analyzeFileDAO = this.daoHelper.getAnalyzeFileDAO();
            analyzeFiles = analyzeFileDAO.findAllByAnalyze(analyze);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by analyze", ex);
        }
        return analyzeFiles;
    }

    public int getNextBioBatchNumber() {
        int result = 0;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getNextRangeIdBetween(this.config.getBatchRangeBioStart(), this.config.getBatchRangeBioEnd());
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public int getNextNonBioBatchNumber() {
        int result = 0;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            result = batchDAO.getNextRangeIdBetween(this.config.getBatchRangeNonBioStart(), this.config.getBatchRangeNonBioEnd());
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public Analyze getAnalyzeById(String analyzeId) {
        Analyze result = null;
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            result = (Analyze)analyzeDAO.findByTopiaId(analyzeId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    public void saveAnalyze(Analyze analyze) {
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            analyzeDAO.create(analyze);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't create analyze", ex);
        }
    }

    public InputStream getAnalyzeDataStream(AnalyzeFile analyzeFile) {
        InputStream result = null;
        try {
            result = analyzeFile.getData().getBinaryStream();
        }
        catch (SQLException ex) {
            throw new SgqBusinessException("Can't get analyze input stream", ex);
        }
        return result;
    }

    public List<Analyze> getAnalysisToSend(AnalyzeFilter analyzeFilter) {
        List<Analyze> result = null;
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            result = analyzeDAO.findAllAnalyzeToSend(analyzeFilter);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analysis", ex);
        }
        return result;
    }

    public List<Analyze> getAnalysisToReceive(AnalyzeFilter analyzeFilter) {
        List<Analyze> result = null;
        try {
            AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
            result = analyzeDAO.findAllAnalyzeToReceive(analyzeFilter);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analysis", ex);
        }
        return result;
    }

    public List<ImportLog<Batch>> importBatchFile(File batchFile) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing batch from file " + batchFile));
        }
        Table table = new Table(batchFile);
        ArrayList<ImportLog<Batch>> importLogs = new ArrayList<ImportLog<Batch>>();
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            int nonBioStart = this.getNextNonBioBatchNumber();
            int nonBioEnd = this.config.getBatchRangeNonBioEnd();
            int bioStart = this.getNextBioBatchNumber();
            int bioEnd = this.config.getBatchRangeBioEnd();
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy");
            table = new Table(batchFile, "UTF-8");
            table.open();
            int line = 0;
            Iterator recordIterator = table.recordIterator();
            while (recordIterator.hasNext()) {
                ++line;
                Record record = (Record)recordIterator.next();
                int num = record.getNumberValue("LOT_R").intValue();
                if (nonBioStart <= num && num <= nonBioEnd || bioStart <= num && num <= bioEnd) {
                    Date dateEntree = record.getDateValue("DATE_R");
                    Number commande = record.getNumberValue("COMM_R");
                    Number colis = record.getNumberValue("COLIS_R");
                    Number poids = record.getNumberValue("POIDS_R");
                    String codeProduit = record.getStringValue("PROD_R").trim();
                    String origin = record.getStringValue("PAYS_R").trim();
                    String dluo = record.getStringValue("DLUO_R").trim();
                    String echantillon = record.getStringValue("ECH_R").trim();
                    String remarque = record.getStringValue("REM_R").trim();
                    String hash = SgqUtils.getSHA1Hash(df.format(dateEntree), String.valueOf(commande), String.valueOf(colis), String.valueOf(poids), codeProduit, origin, dluo, echantillon, remarque);
                    Batch batch = this.getBatchByNumber(num);
                    if (batch == null) {
                        batch = new BatchImpl();
                    } else if (hash.equals(batch.getImportHash())) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Import hashcode unchanged for batch " + num));
                        continue;
                    }
                    ImportLog<Batch> importLog = new ImportLog<Batch>();
                    importLog.setLine(line);
                    importLog.setCode(String.valueOf(num));
                    importLogs.add(importLog);
                    if (commande == null || commande.intValue() <= 0) {
                        importLog.setError(true);
                        importLog.setMessage(I18n._((String)"Numero de commande interne invalide : %d", (Object[])new Object[]{commande}));
                        continue;
                    }
                    PresentationCode codePres = null;
                    if (codeProduit.length() == 6) {
                        codePres = PresentationCode.getPresentationCodeFor(codeProduit.charAt(0));
                        if (codePres == null) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Code pr\u00e9sentation inconnu : %s", (Object[])new Object[]{codeProduit}));
                            continue;
                        }
                        if (codePres == PresentationCode.A || codePres == PresentationCode.B || codePres == PresentationCode.D) {
                            importLog.setError(true);
                            importLog.setMessage(I18n._((String)"Code pr\u00e9sentation destin\u00e9 \u00e0 la vente seulement : %s", (Object[])new Object[]{codeProduit}));
                            continue;
                        }
                        codeProduit = codeProduit.substring(1);
                        if ((codePres == PresentationCode.F || codePres == PresentationCode.T) && codeProduit.charAt(0) == '0') {
                            codeProduit = codeProduit.substring(1);
                        }
                    } else {
                        importLog.setError(true);
                        importLog.setMessage(I18n._((String)"Code produit invalide (6 charact\u00e8res) : %s", (Object[])new Object[]{codeProduit}));
                        continue;
                    }
                    if (colis == null || colis.intValue() <= 0) {
                        importLog.setError(true);
                        importLog.setMessage(I18n._((String)"Nombre de colis invalide : %d", (Object[])new Object[]{colis}));
                        continue;
                    }
                    if (poids == null || poids.doubleValue() <= 0.0) {
                        importLog.setError(true);
                        importLog.setMessage(I18n._((String)"Poids invalide : %e", (Object[])new Object[]{poids}));
                        continue;
                    }
                    if (!dluo.matches("\\d\\d(/\\d\\d){2}")) {
                        importLog.setError(true);
                        importLog.setMessage(I18n._((String)"DLUO, format de date invalide : %s", (Object[])new Object[]{dluo}));
                        continue;
                    }
                    if (origin.isEmpty()) {
                        importLog.setError(true);
                        importLog.setMessage(I18n._((String)"Origine invalide : %s", (Object[])new Object[]{origin}));
                        continue;
                    }
                    Object product = productDAO.findByCode(codeProduit);
                    if (product == null) {
                        importLog.setError(true);
                        importLog.setMessage(I18n._((String)"Produit inconnu : %s", (Object[])new Object[]{codeProduit}));
                        continue;
                    }
                    batch.setNumber(num);
                    batch.setOrderNumber(commande.intValue());
                    batch.setProduct((Product)product);
                    batch.setDluo(df.parse(dluo));
                    batch.setEntryDate(dateEntree);
                    batch.setQuantity(poids.doubleValue());
                    batch.setPackageCount(colis.intValue());
                    batch.setOrigin(Country.FR);
                    batch.setSampleCode(echantillon);
                    batch.setComment(remarque);
                    batch.setImportHash(hash);
                    if (batch.getTopiaId() == null) {
                        batch = (Batch)batchDAO.create(batch);
                        Presentation presentation = (Presentation)presentationDAO.create(new Object[0]);
                        presentation.setQuantity(poids.doubleValue());
                        presentation.setBatch(batch);
                        presentation.setPresentationCode(codePres);
                        importLog.setMessage(I18n._((String)"Lot import\u00e9", (Object[])new Object[0]));
                    } else {
                        batch = (Batch)batchDAO.update(batch);
                        importLog.setMessage(I18n._((String)"Lot mis \u00e0 jour", (Object[])new Object[0]));
                    }
                    importLog.setBean(batch);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Skipping product " + num + " (out of range)"));
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't commit modification in database", ex);
        }
        catch (IOException ex) {
            throw new SgqBusinessException("Can't read dfb file", ex);
        }
        catch (CorruptedTableException ex) {
            throw new SgqBusinessException(I18n._((String)"Format de fichier invalide ou corrompu", (Object[])new Object[0]), ex);
        }
        catch (ParseException ex) {
            throw new SgqBusinessException("Can't parse data", ex);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException ex) {
                    throw new SgqBusinessException("Can't close dbf file", ex);
                }
            }
        }
        return importLogs;
    }

    public void prepareAnalyze(Batch batch, AnalyzeType analyzeType) {
        block4: {
            if (batch == null) {
                throw new NullPointerException("batch can't be null");
            }
            if (analyzeType == null) {
                throw new NullPointerException("analyzeType can't be null");
            }
            try {
                AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
                Analyze analyze = (Analyze)analyzeDAO.create(new Object[0]);
                analyze.setAnalyzeType(analyzeType);
                analyze.setBatch(batch);
                analyzeDAO.update(analyze);
                this.daoHelper.commit();
            }
            catch (TopiaException ex) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Can't prepare analyze", (Throwable)ex);
            }
        }
    }

    public void sendAnalyzeToSupplier(Analyze analyze, Date sentDate, Supplier supplier) {
        block2: {
            try {
                AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
                analyze.setSupplier(supplier);
                analyze.setSentDate(sentDate);
                analyzeDAO.update(analyze);
                this.daoHelper.commit();
            }
            catch (TopiaException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't send analyze to supplier", (Throwable)ex);
            }
        }
    }

    public void receiveAnalyzeFromSupplier(Analyze analyze, Supplier supplier) {
        block2: {
            try {
                AnalyzeDAO analyzeDAO = this.daoHelper.getAnalyzeDAO();
                analyze.setSupplier(supplier);
                analyzeDAO.update(analyze);
                this.daoHelper.commit();
            }
            catch (TopiaException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't send analyze to supplier", (Throwable)ex);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAnalyzeFile(Batch batch, Analyze analyze, String fileName, File file) {
        if (batch == null && analyze == null) {
            throw new NullPointerException("batch and analyze can't both be null");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Blob blob = Hibernate.createBlob((InputStream)is);
            ((InputStream)is).close();
            AnalyzeFileDAO analyzeFileDAO = this.daoHelper.getAnalyzeFileDAO();
            AnalyzeFile analyzeFile = (AnalyzeFile)analyzeFileDAO.create(new Object[0]);
            analyzeFile.setName(fileName);
            analyzeFile.setData(blob);
            analyzeFile.setBatch(batch);
            analyzeFile.setAnalyze(analyze);
            this.daoHelper.commit();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't read file content", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't save file in database", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    public AnalyzeFile getAnalyzeFileById(String analyzeFileId) {
        AnalyzeFile result = null;
        try {
            AnalyzeFileDAO analyzeFileDAO = this.daoHelper.getAnalyzeFileDAO();
            result = (AnalyzeFile)analyzeFileDAO.findByTopiaId(analyzeFileId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't find by id", ex);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File generateControlFile(Batch batch) {
        File result = null;
        FileOutputStream os = null;
        try {
            String out = this.getControlHtmlContent(batch);
            Document document = SgqUtils.parseDocument(out.toString());
            result = File.createTempFile("batchcontrol-", ".pdf");
            os = new FileOutputStream(result);
            ITextRenderer renderer = new ITextRenderer();
            URL baseUrl = BatchService.class.getResource("/ftl/botanic.ftl");
            String url = StringUtils.removeEnd((String)baseUrl.toExternalForm(), (String)"botanic.ftl");
            renderer.setDocument(document, url);
            renderer.layout();
            renderer.createPDF((OutputStream)os);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't generate control file", ex);
                catch (DocumentException ex2) {
                    throw new SgqBusinessException("Can't generate control file", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
        return result;
    }

    protected String getControlHtmlContent(Batch batch) {
        Configuration freemarkerConfiguration = new Configuration();
        freemarkerConfiguration.setEncoding(Locale.getDefault(), "UTF-8");
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(BatchService.class, "/ftl");
        freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
        freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new BeansWrapper());
        String result = null;
        try {
            Template mapTemplate = null;
            if (batch.getProduct().isBotanicControl()) {
                mapTemplate = freemarkerConfiguration.getTemplate("botanic.ftl");
            } else if (batch.getProduct().isIdentificationControl()) {
                mapTemplate = freemarkerConfiguration.getTemplate("identification.ftl");
            } else {
                throw new IllegalArgumentException("Batch product doesn't define any control");
            }
            HashMap<String, Batch> root = new HashMap<String, Batch>();
            root.put("batch", batch);
            StringWriter out = new StringWriter();
            mapTemplate.process(root, (Writer)out);
            ((Writer)out).flush();
            result = ((Object)out).toString();
        }
        catch (IOException ex) {
            throw new SgqBusinessException("Can't generate control file", ex);
        }
        catch (TemplateException ex) {
            throw new SgqBusinessException("Can't generate control file", ex);
        }
        return result;
    }

    public String getControlFilename(Batch batch) {
        String result = null;
        result = batch.getProduct().isBotanicControl() ? "CB" : "CI";
        result = result + "_" + batch.getProduct().getName() + "_" + batch.getNumber() + ".pdf";
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void recoverBatchFile(File file) {
        long before = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            log.info((Object)("Recovering numero lot file " + file.getAbsolutePath()));
        }
        InputStreamReader reader = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            HashMap<String, Client> clients = new HashMap<String, Client>();
            for (Client client : clientDAO.findAll()) {
                clients.put(client.getCode(), client);
            }
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            HashMap<String, Supplier> suppliers = new HashMap<String, Supplier>();
            for (Supplier supplier : supplierDAO.findAll()) {
                suppliers.put(supplier.getCode(), supplier);
            }
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            HashMap<String, Product> products = new HashMap<String, Product>();
            for (Product product : productDAO.findAll()) {
                products.put(product.getCode(), product);
            }
            if (batchDAO.count() > 0L) {
                throw new SgqBusinessException("Can't recover batch file, if batch already exist in database !");
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(file), this.config.getImportCsvFileEncoding());
            BatchImportModel model = new BatchImportModel(suppliers, clients, products);
            ImportConf conf = new ImportConf();
            conf.setStrictMode(false);
            Import2 importCsv = Import2.newImport((ImportConf)conf, (ImportModel)model, (Reader)reader);
            for (ImportRow row : importCsv) {
                Batch bean = (Batch)row.getBean();
                if (row.isValid()) {
                    bean = (Batch)batchDAO.create(bean);
                    Presentation presentation = (Presentation)presentationDAO.create(new Object[0]);
                    presentation.setPresentationCode(PresentationCode._);
                    presentation.setBatch(bean);
                    presentation.setQuantity(bean.getQuantity());
                    presentationDAO.update(presentation);
                    continue;
                }
                Throwable cause = null;
                Iterator i$ = row.getErrors().iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        throw new SgqBusinessException("Can't commit import with errors", cause);
                    }
                    AbstractImportErrorInfo error = (AbstractImportErrorInfo)i$.next();
                    if (cause != null) continue;
                    cause = error.getCause();
                }
            }
            this.daoHelper.commit();
            ((Reader)reader).close();
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't read csv file", ex);
                catch (TopiaException ex2) {
                    throw new SgqBusinessException("Can't commit modification in database", ex2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        if (log.isInfoEnabled()) {
            long after = System.currentTimeMillis();
            log.info((Object)("File imported in " + (after - before) + " ms"));
        }
    }

    public InputStream exportInventory() {
        FileInputStream result = null;
        try {
            File file = File.createTempFile("inventory", ".csv");
            file.deleteOnExit();
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            List<BatchModel> batchModels = batchDAO.findAllModel(new SearchModel(), 0, -1);
            ArrayList<InventoryBean> beans = new ArrayList<InventoryBean>();
            for (BatchModel batchModel : batchModels) {
                List<PresentationModel> presentationModels = this.findAllPresentationsByBatch(batchModel.getBatch());
                for (PresentationModel model : presentationModels) {
                    List<Place> places = model.getPlaces();
                    if (CollectionUtils.isNotEmpty(places)) {
                        for (Place place : places) {
                            InventoryBean bean = new InventoryBean();
                            bean.setBatch(batchModel.getBatch());
                            bean.setBatchModel(batchModel);
                            bean.setPresentation(model.getPresentation());
                            bean.setPlace(place);
                            beans.add(bean);
                        }
                        continue;
                    }
                    InventoryBean bean = new InventoryBean();
                    bean.setBatch(batchModel.getBatch());
                    bean.setPresentation(model.getPresentation());
                    bean.setBatchModel(batchModel);
                    beans.add(bean);
                }
            }
            InventoryExportModel model = new InventoryExportModel();
            String csv = Export.exportToString((ExportModel)model, beans, (Charset)Charset.forName(this.config.getImportCsvFileEncoding()));
            FileUtils.writeStringToFile((File)file, (String)csv, (String)this.config.getImportCsvFileEncoding());
            result = new FileInputStream(file);
        }
        catch (Exception ex) {
            throw new SgqBusinessException("Can't write csv file", ex);
        }
        return result;
    }

    public Map<Place, List<PresentationModel>> findAllBatchPerPlaces(Place place) {
        HashMap<Place, List<PresentationModel>> result = null;
        try {
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            List batches = batchDAO.findAll();
            result = new HashMap<Place, List<PresentationModel>>();
            for (Batch batch : batches) {
                List<PresentationModel> presentationModels = this.findAllPresentationsByBatch(batch);
                for (PresentationModel model : presentationModels) {
                    List<Place> places = model.getPlaces();
                    for (Place presPlace : places) {
                        if (place != null && !place.equals(presPlace)) continue;
                        ArrayList<PresentationModel> batchList = (ArrayList<PresentationModel>)result.get(presPlace);
                        if (batchList == null) {
                            batchList = new ArrayList<PresentationModel>();
                            result.put(presPlace, batchList);
                        }
                        batchList.add(model);
                    }
                }
            }
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't read database", ex);
        }
        return result;
    }
}

