package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class BatchAbstract extends TopiaEntityAbstract implements Batch {

    /**
     * Nom de l'attribut en BD : number
     */
    protected int number;

    /**
     * Nom de l'attribut en BD : orderNumber
     */
    protected long orderNumber;

    /**
     * Nom de l'attribut en BD : entryDate
     */
    protected Date entryDate;

    /**
     * Nom de l'attribut en BD : dmesd
     */
    protected Date dmesd;

    /**
     * Nom de l'attribut en BD : dpmes
     */
    protected Date dpmes;

    /**
     * Nom de l'attribut en BD : dluo
     */
    protected Date dluo;

    /**
     * Si non null, le lot devient invisible dans le système.
     * Nom de l'attribut en BD : elapsedDate
     */
    protected Date elapsedDate;

    /**
     * Nom de l'attribut en BD : quantity
     */
    protected double quantity;

    /**
     * Nom de l'attribut en BD : packageCount
     */
    protected int packageCount;

    /**
     * Nom de l'attribut en BD : sampleCode
     */
    protected String sampleCode;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Code de hashage pour détecter des modifications entre deux imports.
     * Nom de l'attribut en BD : importHash
     */
    protected String importHash;

    /**
     * Un lot invalide doit être ignoré pas le système SQG
     * Nom de l'attribut en BD : invalid
     */
    protected boolean invalid;

    /**
     * Nom de l'attribut en BD : supplier
     */
    protected Supplier supplier;

    /**
     * Nom de l'attribut en BD : product
     */
    protected Product product;

    /**
     * Nom de l'attribut en BD : dedicatedClient
     */
    protected Client dedicatedClient;

    /**
     * Nom de l'attribut en BD : origin
     */
    protected Country origin;

    private static final long serialVersionUID = 7234243577027901745L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NUMBER, int.class, number);
        visitor.visit(this, PROPERTY_ORDER_NUMBER, long.class, orderNumber);
        visitor.visit(this, PROPERTY_ENTRY_DATE, Date.class, entryDate);
        visitor.visit(this, PROPERTY_DMESD, Date.class, dmesd);
        visitor.visit(this, PROPERTY_DPMES, Date.class, dpmes);
        visitor.visit(this, PROPERTY_DLUO, Date.class, dluo);
        visitor.visit(this, PROPERTY_ELAPSED_DATE, Date.class, elapsedDate);
        visitor.visit(this, PROPERTY_QUANTITY, double.class, quantity);
        visitor.visit(this, PROPERTY_PACKAGE_COUNT, int.class, packageCount);
        visitor.visit(this, PROPERTY_SAMPLE_CODE, String.class, sampleCode);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_IMPORT_HASH, String.class, importHash);
        visitor.visit(this, PROPERTY_INVALID, boolean.class, invalid);
        visitor.visit(this, PROPERTY_SUPPLIER, Supplier.class, supplier);
        visitor.visit(this, PROPERTY_PRODUCT, Product.class, product);
        visitor.visit(this, PROPERTY_DEDICATED_CLIENT, Client.class, dedicatedClient);
        visitor.visit(this, PROPERTY_ORIGIN, Country.class, origin);
        visitor.end(this);
    }

    @Override
    public void setNumber(int number) {
        int oldValue = this.number;
        fireOnPreWrite(PROPERTY_NUMBER, oldValue, number);
        this.number = number;
        fireOnPostWrite(PROPERTY_NUMBER, oldValue, number);
    }

    @Override
    public int getNumber() {
        fireOnPreRead(PROPERTY_NUMBER, number);
        int result = this.number;
        fireOnPostRead(PROPERTY_NUMBER, number);
        return result;
    }

    @Override
    public void setOrderNumber(long orderNumber) {
        long oldValue = this.orderNumber;
        fireOnPreWrite(PROPERTY_ORDER_NUMBER, oldValue, orderNumber);
        this.orderNumber = orderNumber;
        fireOnPostWrite(PROPERTY_ORDER_NUMBER, oldValue, orderNumber);
    }

    @Override
    public long getOrderNumber() {
        fireOnPreRead(PROPERTY_ORDER_NUMBER, orderNumber);
        long result = this.orderNumber;
        fireOnPostRead(PROPERTY_ORDER_NUMBER, orderNumber);
        return result;
    }

    @Override
    public void setEntryDate(Date entryDate) {
        Date oldValue = this.entryDate;
        fireOnPreWrite(PROPERTY_ENTRY_DATE, oldValue, entryDate);
        this.entryDate = entryDate;
        fireOnPostWrite(PROPERTY_ENTRY_DATE, oldValue, entryDate);
    }

    @Override
    public Date getEntryDate() {
        fireOnPreRead(PROPERTY_ENTRY_DATE, entryDate);
        Date result = this.entryDate;
        fireOnPostRead(PROPERTY_ENTRY_DATE, entryDate);
        return result;
    }

    @Override
    public void setDmesd(Date dmesd) {
        Date oldValue = this.dmesd;
        fireOnPreWrite(PROPERTY_DMESD, oldValue, dmesd);
        this.dmesd = dmesd;
        fireOnPostWrite(PROPERTY_DMESD, oldValue, dmesd);
    }

    @Override
    public Date getDmesd() {
        fireOnPreRead(PROPERTY_DMESD, dmesd);
        Date result = this.dmesd;
        fireOnPostRead(PROPERTY_DMESD, dmesd);
        return result;
    }

    @Override
    public void setDpmes(Date dpmes) {
        Date oldValue = this.dpmes;
        fireOnPreWrite(PROPERTY_DPMES, oldValue, dpmes);
        this.dpmes = dpmes;
        fireOnPostWrite(PROPERTY_DPMES, oldValue, dpmes);
    }

    @Override
    public Date getDpmes() {
        fireOnPreRead(PROPERTY_DPMES, dpmes);
        Date result = this.dpmes;
        fireOnPostRead(PROPERTY_DPMES, dpmes);
        return result;
    }

    @Override
    public void setDluo(Date dluo) {
        Date oldValue = this.dluo;
        fireOnPreWrite(PROPERTY_DLUO, oldValue, dluo);
        this.dluo = dluo;
        fireOnPostWrite(PROPERTY_DLUO, oldValue, dluo);
    }

    @Override
    public Date getDluo() {
        fireOnPreRead(PROPERTY_DLUO, dluo);
        Date result = this.dluo;
        fireOnPostRead(PROPERTY_DLUO, dluo);
        return result;
    }

    @Override
    public void setElapsedDate(Date elapsedDate) {
        Date oldValue = this.elapsedDate;
        fireOnPreWrite(PROPERTY_ELAPSED_DATE, oldValue, elapsedDate);
        this.elapsedDate = elapsedDate;
        fireOnPostWrite(PROPERTY_ELAPSED_DATE, oldValue, elapsedDate);
    }

    @Override
    public Date getElapsedDate() {
        fireOnPreRead(PROPERTY_ELAPSED_DATE, elapsedDate);
        Date result = this.elapsedDate;
        fireOnPostRead(PROPERTY_ELAPSED_DATE, elapsedDate);
        return result;
    }

    @Override
    public void setQuantity(double quantity) {
        double oldValue = this.quantity;
        fireOnPreWrite(PROPERTY_QUANTITY, oldValue, quantity);
        this.quantity = quantity;
        fireOnPostWrite(PROPERTY_QUANTITY, oldValue, quantity);
    }

    @Override
    public double getQuantity() {
        fireOnPreRead(PROPERTY_QUANTITY, quantity);
        double result = this.quantity;
        fireOnPostRead(PROPERTY_QUANTITY, quantity);
        return result;
    }

    @Override
    public void setPackageCount(int packageCount) {
        int oldValue = this.packageCount;
        fireOnPreWrite(PROPERTY_PACKAGE_COUNT, oldValue, packageCount);
        this.packageCount = packageCount;
        fireOnPostWrite(PROPERTY_PACKAGE_COUNT, oldValue, packageCount);
    }

    @Override
    public int getPackageCount() {
        fireOnPreRead(PROPERTY_PACKAGE_COUNT, packageCount);
        int result = this.packageCount;
        fireOnPostRead(PROPERTY_PACKAGE_COUNT, packageCount);
        return result;
    }

    @Override
    public void setSampleCode(String sampleCode) {
        String oldValue = this.sampleCode;
        fireOnPreWrite(PROPERTY_SAMPLE_CODE, oldValue, sampleCode);
        this.sampleCode = sampleCode;
        fireOnPostWrite(PROPERTY_SAMPLE_CODE, oldValue, sampleCode);
    }

    @Override
    public String getSampleCode() {
        fireOnPreRead(PROPERTY_SAMPLE_CODE, sampleCode);
        String result = this.sampleCode;
        fireOnPostRead(PROPERTY_SAMPLE_CODE, sampleCode);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public void setImportHash(String importHash) {
        String oldValue = this.importHash;
        fireOnPreWrite(PROPERTY_IMPORT_HASH, oldValue, importHash);
        this.importHash = importHash;
        fireOnPostWrite(PROPERTY_IMPORT_HASH, oldValue, importHash);
    }

    @Override
    public String getImportHash() {
        fireOnPreRead(PROPERTY_IMPORT_HASH, importHash);
        String result = this.importHash;
        fireOnPostRead(PROPERTY_IMPORT_HASH, importHash);
        return result;
    }

    @Override
    public void setInvalid(boolean invalid) {
        boolean oldValue = this.invalid;
        fireOnPreWrite(PROPERTY_INVALID, oldValue, invalid);
        this.invalid = invalid;
        fireOnPostWrite(PROPERTY_INVALID, oldValue, invalid);
    }

    @Override
    public boolean isInvalid() {
        fireOnPreRead(PROPERTY_INVALID, invalid);
        boolean result = this.invalid;
        fireOnPostRead(PROPERTY_INVALID, invalid);
        return result;
    }

    @Override
    public boolean getInvalid() {
        fireOnPreRead(PROPERTY_INVALID, invalid);
        boolean result = this.invalid;
        fireOnPostRead(PROPERTY_INVALID, invalid);
        return result;
    }

    @Override
    public void setSupplier(Supplier supplier) {
        Supplier oldValue = this.supplier;
        fireOnPreWrite(PROPERTY_SUPPLIER, oldValue, supplier);
        this.supplier = supplier;
        fireOnPostWrite(PROPERTY_SUPPLIER, oldValue, supplier);
    }

    @Override
    public Supplier getSupplier() {
        fireOnPreRead(PROPERTY_SUPPLIER, supplier);
        Supplier result = this.supplier;
        fireOnPostRead(PROPERTY_SUPPLIER, supplier);
        return result;
    }

    @Override
    public void setProduct(Product product) {
        Product oldValue = this.product;
        fireOnPreWrite(PROPERTY_PRODUCT, oldValue, product);
        this.product = product;
        fireOnPostWrite(PROPERTY_PRODUCT, oldValue, product);
    }

    @Override
    public Product getProduct() {
        fireOnPreRead(PROPERTY_PRODUCT, product);
        Product result = this.product;
        fireOnPostRead(PROPERTY_PRODUCT, product);
        return result;
    }

    @Override
    public void setDedicatedClient(Client dedicatedClient) {
        Client oldValue = this.dedicatedClient;
        fireOnPreWrite(PROPERTY_DEDICATED_CLIENT, oldValue, dedicatedClient);
        this.dedicatedClient = dedicatedClient;
        fireOnPostWrite(PROPERTY_DEDICATED_CLIENT, oldValue, dedicatedClient);
    }

    @Override
    public Client getDedicatedClient() {
        fireOnPreRead(PROPERTY_DEDICATED_CLIENT, dedicatedClient);
        Client result = this.dedicatedClient;
        fireOnPostRead(PROPERTY_DEDICATED_CLIENT, dedicatedClient);
        return result;
    }

    @Override
    public void setOrigin(Country origin) {
        Country oldValue = this.origin;
        fireOnPreWrite(PROPERTY_ORIGIN, oldValue, origin);
        this.origin = origin;
        fireOnPostWrite(PROPERTY_ORIGIN, oldValue, origin);
    }

    @Override
    public Country getOrigin() {
        fireOnPreRead(PROPERTY_ORIGIN, origin);
        Country result = this.origin;
        fireOnPostRead(PROPERTY_ORIGIN, origin);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //BatchAbstract
