/*
 * #%L
 * SGQ :: Business
 * $Id: BatchModel.java 104 2012-09-27 10:22:27Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-business/src/main/java/com/herbocailleau/sgq/business/model/BatchModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.model;

import java.util.Date;

import com.herbocailleau.sgq.entities.Batch;

/**
 * Model de presentation d'un lot, englobant en plus la quantité totale
 * restante suivant les quantités des présentations.
 * 
 * @author echatellier
 */
public class BatchModel {

    protected Batch batch;

    protected double totalPresentation;

    protected double totalSale;

    protected Date dmes;

    public BatchModel(Batch batch, double totalPresentation, double totalSale, Date dmes) {
        this.batch = batch;
        this.totalPresentation = totalPresentation;
        this.totalSale = totalSale;
        this.dmes = dmes;
    }

    public Batch getBatch() {
        return batch;
    }

    public double getTotalPresentation() {
        return totalPresentation;
    }
    
    public double getTotalSale() {
        return totalSale;
    }
    
    public Date getDmes() {
        return dmes;
    }
}
