/*
 * #%L
 * SGQ :: Business
 * $Id: SgqUtils.java 107 2012-10-01 14:26:37Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-business/src/main/java/com/herbocailleau/sgq/business/SgqUtils.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import static org.nuiton.i18n.I18n._;

import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.nuiton.util.StringUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.herbocailleau.sgq.entities.Product;

public class SgqUtils {

    protected static final DateFormat DF_DDMMYYY = new SimpleDateFormat("dd/MM/yyyy");

    /**
     * Return true if client is an internal client (production/expedition process).
     * 
     * @param config config to get internal client id
     * @param clientId client id to test
     * @return true or false
     */
    public static boolean isInternalClient(SgqBusinessConfig config, int clientId) {
        boolean result = false;
        result |= config.getClientInternalZc() == clientId;
        result |= config.getClientInternalZe() == clientId;
        result |= config.getClientInternalZp() == clientId;
        return result;
    }

    /**
     * Les unités des produits sont définis par le prefix de leurs code.
     * 
     * <ul>
     * <li>ZU,ZY : 1000 unit
     * <li>ZX,ZV : L
     * <li>Le reste : kg
     * </ul>
     * 
     * TODO echatellier à voir comment lié ca à la configuration, c'est pas
     *  super évident.
     *  
     * @return l'unité du produit
     */
    public static String getProductUnit(SgqBusinessConfig config, Product product) {
        String code = product.getCode();
        String result = null;
        if (code.charAt(0) == 'Z') {
            switch (code.charAt(1)) {
            case 'U':
            case 'Y':
                result = _("000 Unit\u00E9s");
                break;
            case 'X':
            case 'V':
                result = _("L");
                break;
            default:
                result = _("kg");
            }
        } else {
            result = _("kg");
        }
        return result;
    }

    /**
     * Convert string to {@link Document}.
     * 
     * TODO echatellier peut-etre une methode à extraire car utilisée dans
     *  plusieurs projet
     *  
     * @param content content
     * @return document
     * @throws IOException 
     */
    public static Document parseDocument(String content) throws IOException {
        Document result = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            result = builder.parse(new InputSource(new StringReader(content)));
        } catch (ParserConfigurationException e) {
            throw new IOException(e);
        } catch (SAXException e) {
            throw new IOException(e);
        }
        return result;
    }

    /**
     * Parse sgq date in dd/MM/yyyy date format.
     * 
     * @param value value to parse
     * @return parsed date
     * @throws ParseException 
     */
    public static Date parseSgqDate(String value) throws ParseException {
        return DF_DDMMYYY.parse(value);
    }
    
    /**
     * Format sgq date in dd/MM/yyyy date format.
     * 
     * @param value value to parse
     * @return parsed date
     */
    public static String formatSgqDate(Date value) {
        return DF_DDMMYYY.format(value);
    }

    /**
     * Get sha1 encoding for string list
     * 
     * @param values
     * @return
     */
    public static String getSHA1Hash(String... values) {
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append(value);
        }
        return StringUtil.encodeSHA1(builder.toString());
    }
}
