/*
 * #%L
 * SGQ :: Business
 * $Id: ServiceFactory.java 62 2012-09-13 16:42:45Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.3/sgq-business/src/main/java/com/herbocailleau/sgq/business/ServiceFactory.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import java.util.Properties;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaNotFoundException;

import com.herbocailleau.sgq.SGQDAOHelper;

/**
 * Factory des services.
 * 
 * @author echatellier
 */
public class ServiceFactory {

    protected static TopiaContext rootContext;

    protected static SgqBusinessConfig config;

    public static SgqBusinessConfig getConfig() {
        if (config == null) {
            config = new SgqBusinessConfig();
            config.parse();
        }
        return config;
    }

    public static TopiaContext getRootContext() {

        if (rootContext == null) {
            SgqBusinessConfig config = getConfig();
            Properties props = config.getFlatOptions();

            props.setProperty(TopiaContextFactory.CONFIG_PERSISTENCE_CLASSES,
                    SGQDAOHelper.getImplementationClassesAsString());

            try {
                rootContext = TopiaContextFactory.getContext(props);
            } catch (TopiaNotFoundException ex) {
                throw new RuntimeException("Can't init root context", ex);
            }
        }

        return rootContext;
    }

    public static <E extends SgqService> E newService(Class<E> serviceClass, TopiaContext transaction) {
        E service = null;

        try {
            service = serviceClass.newInstance();
        } catch (InstantiationException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        } catch (IllegalAccessException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        }
        ServiceDAOHelper daoHelper = new ServiceDAOHelper(transaction);
        service.setServiceDAOHelper(daoHelper);
        service.setConfig(getConfig());

        return service;
    }
}
