/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeCategoryDAO;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.AnalyzeTypeDAO;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientDAO;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PlaceDAO;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductDAO;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SupplierDAO;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.xBaseJ.DBF;
import org.xBaseJ.fields.CharField;
import org.xBaseJ.fields.NumField;

public class ReferentialService
extends SgqService {
    private static final Log log = LogFactory.getLog(ReferentialService.class);

    public void importClients(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing client from file " + file.getAbsolutePath()));
        }
        DBF fileDB = null;
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            fileDB = new DBF(file.getAbsolutePath(), 'r', "UTF-8");
            CharField codeField = (CharField)fileDB.getField("code");
            CharField nameField = (CharField)fileDB.getField("nom");
            for (int i = 0; i < fileDB.getRecordCount(); ++i) {
                fileDB.read();
                Object client = clientDAO.createByNaturalId(codeField.get());
                client.setName(nameField.get());
                clientDAO.update((TopiaEntity)client);
            }
            this.daoHelper.commit();
        }
        catch (Exception ex) {
            try {
                throw new SgqBusinessException("Can't read dbf file", ex);
            }
            catch (Throwable throwable) {
                SgqUtils.closeFile(fileDB);
                throw throwable;
            }
        }
        SgqUtils.closeFile(fileDB);
    }

    public void importProducts(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing products from file " + file.getAbsolutePath()));
        }
        DBF fileDB = null;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            fileDB = new DBF(file.getAbsolutePath(), 'r', "UTF-8");
            CharField codeField = (CharField)fileDB.getField("code");
            CharField nameField = (CharField)fileDB.getField("name");
            CharField latinNameField = (CharField)fileDB.getField("latinname");
            CharField familyField = (CharField)fileDB.getField("family");
            for (int i = 0; i < fileDB.getRecordCount(); ++i) {
                fileDB.read();
                Object product = productDAO.createByNaturalId(codeField.get());
                product.setName(nameField.get());
                product.setFamily(familyField.get());
                product.setLatinName(latinNameField.get());
                productDAO.update((TopiaEntity)product);
            }
            this.daoHelper.commit();
        }
        catch (Exception ex) {
            try {
                throw new SgqBusinessException("Can't read dbf file", ex);
            }
            catch (Throwable throwable) {
                SgqUtils.closeFile(fileDB);
                throw throwable;
            }
        }
        SgqUtils.closeFile(fileDB);
    }

    public void importPlaces(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing places from file " + file.getAbsolutePath()));
        }
        DBF fileDB = null;
        try {
            PlaceDAO placeDAO = this.daoHelper.getPlaceDAO();
            fileDB = new DBF(file.getAbsolutePath(), 'r', "UTF-8");
            CharField codeField = (CharField)fileDB.getField("code");
            for (int i = 0; i < fileDB.getRecordCount(); ++i) {
                fileDB.read();
                Object place = placeDAO.createByNaturalId(codeField.get());
                placeDAO.update((TopiaEntity)place);
            }
            this.daoHelper.commit();
        }
        catch (Exception ex) {
            try {
                throw new SgqBusinessException("Can't read dbf file", ex);
            }
            catch (Throwable throwable) {
                SgqUtils.closeFile(fileDB);
                throw throwable;
            }
        }
        SgqUtils.closeFile(fileDB);
    }

    public void importSuppliers(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing suppliers from file " + file.getAbsolutePath()));
        }
        DBF fileDB = null;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            fileDB = new DBF(file.getAbsolutePath(), 'r', "UTF-8");
            CharField codeField = (CharField)fileDB.getField("code");
            CharField nameField = (CharField)fileDB.getField("name");
            NumField labField = (NumField)fileDB.getField("lab");
            for (int i = 0; i < fileDB.getRecordCount(); ++i) {
                fileDB.read();
                Object supplier = supplierDAO.createByNaturalId(codeField.get());
                supplier.setName(nameField.get());
                supplier.setLaboratory("1.00".equals(labField.get()));
                supplierDAO.update((TopiaEntity)supplier);
            }
            this.daoHelper.commit();
        }
        catch (Exception ex) {
            try {
                throw new SgqBusinessException("Can't read dbf file", ex);
            }
            catch (Throwable throwable) {
                SgqUtils.closeFile(fileDB);
                throw throwable;
            }
        }
        SgqUtils.closeFile(fileDB);
    }

    public long getClientsCount() {
        long result = 0L;
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            result = clientDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return result;
    }

    public List<Client> getClients(int offset, int count) {
        List results = null;
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            results = clientDAO.findAllByQueryWithBound("from " + Client.class.getName() + " order by " + "code", offset, offset + count - 1, new Object[0]);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return results;
    }

    public Client findClientById(String id) {
        Client result = null;
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            result = (Client)clientDAO.findByTopiaId(id);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get client", ex);
        }
        return result;
    }

    public void saveClient(Client client) {
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            if (StringUtils.isEmpty((CharSequence)client.getTopiaId())) {
                clientDAO.create(client);
            } else {
                clientDAO.update(client);
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't save client", ex);
        }
    }

    public long getPlacesCount() {
        long result = 0L;
        try {
            PlaceDAO placeDAO = this.daoHelper.getPlaceDAO();
            result = placeDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return result;
    }

    public List<Place> getPlaces() {
        List results = null;
        try {
            PlaceDAO placeDAO = this.daoHelper.getPlaceDAO();
            results = placeDAO.findAll();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return results;
    }

    public long getSuppliersCount() {
        long result = 0L;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            result = supplierDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return result;
    }

    public List<Supplier> getSuppliers(int offset, int count) {
        List results = null;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            results = supplierDAO.findAllByQueryWithBound("from " + Supplier.class.getName() + " order by " + "code", offset, offset + count - 1, new Object[0]);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return results;
    }

    public Supplier getSupplierById(String supplierId) {
        Supplier result = null;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            result = (Supplier)supplierDAO.findByTopiaId(supplierId);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get supplier", ex);
        }
        return result;
    }

    public long getProductsCount() {
        long result = 0L;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            result = productDAO.count();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return result;
    }

    public List<Product> getProducts(int offset, int count) {
        List results = null;
        try {
            ProductDAO productDAO = this.daoHelper.getProductDAO();
            results = productDAO.findAllByQueryWithBound("from " + Product.class.getName() + " order by " + "code", offset, offset + count - 1, new Object[0]);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
        return results;
    }

    public void createClient(String code, String name) {
        try {
            ClientDAO clientDAO = this.daoHelper.getClientDAO();
            Object client = clientDAO.createByNaturalId(code);
            client.setName(name);
            clientDAO.update((TopiaEntity)client);
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get count", ex);
        }
    }

    public List<AnalyzeType> findAllAnalyzeTypes() {
        List result = null;
        try {
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            result = analyzeTypeDAO.findAll();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze types", ex);
        }
        return result;
    }

    public AnalyzeType findAnalyzeTypeById(String id) {
        AnalyzeType result = null;
        try {
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            result = (AnalyzeType)analyzeTypeDAO.findByTopiaId(id);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze type", ex);
        }
        return result;
    }

    public void saveAnalyzeType(AnalyzeType analyzeType) {
        try {
            AnalyzeTypeDAO analyzeTypeDAO = this.daoHelper.getAnalyzeTypeDAO();
            if (StringUtils.isEmpty((CharSequence)analyzeType.getTopiaId())) {
                analyzeTypeDAO.create(analyzeType);
            } else {
                analyzeTypeDAO.update(analyzeType);
            }
            this.daoHelper.commit();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't save analyze type", ex);
        }
    }

    public List<AnalyzeCategory> findAllAnalyzeCategories() {
        List result = null;
        try {
            AnalyzeCategoryDAO analyzeCategoryDAO = this.daoHelper.getAnalyzeCategoryDAO();
            result = analyzeCategoryDAO.findAll();
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze categories", ex);
        }
        return result;
    }

    public AnalyzeCategory findAnalyzeCategoryById(String id) {
        AnalyzeCategory result = null;
        try {
            AnalyzeCategoryDAO analyzeCategoryDAO = this.daoHelper.getAnalyzeCategoryDAO();
            result = (AnalyzeCategory)analyzeCategoryDAO.findByTopiaId(id);
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze category", ex);
        }
        return result;
    }

    public List<Supplier> getAllSupplierLabFirst() {
        List result;
        try {
            SupplierDAO supplierDAO = this.daoHelper.getSupplierDAO();
            result = supplierDAO.findAllWithOrder(new String[]{"laboratory DESC", "name ASC"});
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get analyze category", ex);
        }
        return result;
    }
}

