/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business;

import com.herbocailleau.sgq.SGQDAOHelper;
import com.herbocailleau.sgq.business.ServiceDAOHelper;
import com.herbocailleau.sgq.business.SgqBusinessConfig;
import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeCategoryDAO;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;

public class ServiceFactory {
    private static final Log log = LogFactory.getLog(ServiceFactory.class);
    protected static TopiaContext rootContext;
    protected static SgqBusinessConfig config;

    public static SgqBusinessConfig getConfig() {
        if (config == null) {
            config = new SgqBusinessConfig();
            config.parse();
        }
        return config;
    }

    public static TopiaContext getRootContext() {
        if (rootContext == null) {
            SgqBusinessConfig config = ServiceFactory.getConfig();
            Properties props = config.getFlatOptions();
            props.setProperty("topia.persistence.classes", SGQDAOHelper.getImplementationClassesAsString());
            try {
                rootContext = TopiaContextFactory.getContext((Properties)props);
            }
            catch (TopiaNotFoundException ex) {
                throw new RuntimeException("Can't init root context", ex);
            }
            ServiceFactory.initializeDatabase(rootContext);
        }
        return rootContext;
    }

    public static <E extends SgqService> E newService(Class<E> serviceClass, TopiaContext transaction) {
        SgqService service = null;
        try {
            service = (SgqService)serviceClass.newInstance();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        }
        ServiceDAOHelper daoHelper = new ServiceDAOHelper(transaction);
        service.setServiceDAOHelper(daoHelper);
        service.setConfig(ServiceFactory.getConfig());
        return (E)service;
    }

    protected static void initializeDatabase(TopiaContext rootContext) {
        TopiaContext transaction = null;
        try {
            transaction = rootContext.beginTransaction();
            AnalyzeCategoryDAO analyzeCategoryDAO = SGQDAOHelper.getAnalyzeCategoryDAO(transaction);
            long count = analyzeCategoryDAO.count();
            if (log.isInfoEnabled()) {
                log.info((Object)("Found " + count + " analyze categories in database"));
            }
            if (count == 0L) {
                AnalyzeCategory analyzeCat1 = (AnalyzeCategory)analyzeCategoryDAO.create(new Object[0]);
                analyzeCat1.setName("Analyse PC");
                analyzeCategoryDAO.update(analyzeCat1);
                AnalyzeCategory analyzeCat2 = (AnalyzeCategory)analyzeCategoryDAO.create(new Object[0]);
                analyzeCat2.setName("4A Bact\u00e9rio");
                analyzeCategoryDAO.update(analyzeCat2);
                AnalyzeCategory analyzeCat3 = (AnalyzeCategory)analyzeCategoryDAO.create(new Object[0]);
                analyzeCat3.setName("4B 4C Bact\u00e9rio");
                analyzeCategoryDAO.update(analyzeCat3);
                AnalyzeCategory analyzeCat4 = (AnalyzeCategory)analyzeCategoryDAO.create(new Object[0]);
                analyzeCat4.setName("Pesti");
                analyzeCategoryDAO.update(analyzeCat4);
                AnalyzeCategory analyzeCat5 = (AnalyzeCategory)analyzeCategoryDAO.create(new Object[0]);
                analyzeCat5.setName("M\u00e9taux");
                analyzeCategoryDAO.update(analyzeCat5);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Creating category " + analyzeCat1.getName()));
                    log.info((Object)("Creating category " + analyzeCat2.getName()));
                    log.info((Object)("Creating category " + analyzeCat3.getName()));
                    log.info((Object)("Creating category " + analyzeCat4.getName()));
                    log.info((Object)("Creating category " + analyzeCat5.getName()));
                }
                transaction.commitTransaction();
            }
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't init database", ex);
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.closeContext();
                }
                catch (TopiaException ex) {
                    throw new SgqBusinessException("Can't init database", ex);
                }
            }
        }
    }
}

