package com.herbocailleau.sgq.entities;

/*
 * #%L
 * SGQ :: Business
 * $Id: AnalyzeDAOImpl.java 47 2012-09-11 09:23:43Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-business/src/main/java/com/herbocailleau/sgq/entities/AnalyzeDAOImpl.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

import java.util.List;

import org.nuiton.topia.TopiaException;

public class AnalyzeDAOImpl<E extends Analyze> extends AnalyzeDAOAbstract<E> {

    /**
     * Retourne l'ensemble des analyzes a preparer et non encore expédiées.
     * 
     * @param analyzeType analyze type to filter on
     * @throws TopiaException 
     */
    public List<Analyze> findAllAnalyzeToSend(AnalyzeType analyzeType) throws TopiaException {
        String query = "from " + Analyze.class.getName() +
            " where " + Analyze.PROPERTY_SENT_DATE + " is null";
        if (analyzeType != null) {
            query += " and " + Analyze.PROPERTY_ANALYZE_TYPE + " = :" + Analyze.PROPERTY_ANALYZE_TYPE;
        }
        query += " order by " + Analyze.PROPERTY_BATCH + "." + Batch.PROPERTY_DPMES;
        
        List<Analyze> result = null;
        if (analyzeType != null) {
            result = context.findAll(query, Analyze.PROPERTY_ANALYZE_TYPE, analyzeType);
        } else {
            result = context.findAll(query);
        }
        return result;
    }

    /**
     * Retourne l'ensemble des analyzes expédiées en attente de reception.
     * 
     * @param analyzeType analyze type to filter on
     * @throws TopiaException 
     */
    public List<Analyze> findAllAnalyzeToReceive(AnalyzeType analyzeType) throws TopiaException {
        String query = "from " + Analyze.class.getName() +
            " where " + Analyze.PROPERTY_RECEIPT_DATE + " is null" +
            " and " + Analyze.PROPERTY_SENT_DATE + " is not null";
        if (analyzeType != null) {
            query += " and " + Analyze.PROPERTY_ANALYZE_TYPE + " = :" + Analyze.PROPERTY_ANALYZE_TYPE;
        }
        query += " order by " + Analyze.PROPERTY_BATCH + "." + Batch.PROPERTY_DPMES;
        
        List<Analyze> result = null;
        if (analyzeType != null) {
            result = context.findAll(query, Analyze.PROPERTY_ANALYZE_TYPE, analyzeType);
        } else {
            result = context.findAll(query);
        }
        return result;
    }

} //AnalyzeDAOImpl<E extends Analyze>
