/*
 * #%L
 * SGQ :: Business
 * $Id: ServiceFactory.java 48 2012-09-11 12:46:57Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.2/sgq-business/src/main/java/com/herbocailleau/sgq/business/ServiceFactory.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;

import com.herbocailleau.sgq.SGQDAOHelper;
import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeCategoryDAO;

/**
 * Factory des services.
 * 
 * @author echatellier
 */
public class ServiceFactory {

    private static final Log log = LogFactory.getLog(ServiceFactory.class);

    protected static TopiaContext rootContext;

    protected static SgqBusinessConfig config;

    public static SgqBusinessConfig getConfig() {
        if (config == null) {
            config = new SgqBusinessConfig();
            config.parse();
        }
        return config;
    }

    public static TopiaContext getRootContext() {

        if (rootContext == null) {
            SgqBusinessConfig config = getConfig();
            Properties props = config.getFlatOptions();

            props.setProperty(TopiaContextFactory.CONFIG_PERSISTENCE_CLASSES,
                    SGQDAOHelper.getImplementationClassesAsString());

            try {
                rootContext = TopiaContextFactory.getContext(props);
            } catch (TopiaNotFoundException ex) {
                throw new RuntimeException("Can't init root context", ex);
            }
            
            // initialize database
            initializeDatabase(rootContext);
        }

        return rootContext;
    }

    public static <E extends SgqService> E newService(Class<E> serviceClass, TopiaContext transaction) {
        E service = null;

        try {
            service = serviceClass.newInstance();
        } catch (InstantiationException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        } catch (IllegalAccessException ex) {
            throw new RuntimeException("Can't instanciate service", ex);
        }
        ServiceDAOHelper daoHelper = new ServiceDAOHelper(transaction);
        service.setServiceDAOHelper(daoHelper);
        service.setConfig(getConfig());

        return service;
    }
    
    protected static void initializeDatabase(TopiaContext rootContext) {

        // get init transaction
        TopiaContext transaction = null;
        try {
            transaction = rootContext.beginTransaction();

            // test if analyze category already exists
            // ces types sont fixes car les fichiers d'imports et l'organisation
            // des interfaces graphiques en dépend
            AnalyzeCategoryDAO analyzeCategoryDAO = SGQDAOHelper.getAnalyzeCategoryDAO(transaction);
            long count = analyzeCategoryDAO.count();
            
            if (log.isInfoEnabled()) {
                log.info("Found " + count + " analyze categories in database");
            }

            if (count == 0) {
                AnalyzeCategory analyzeCat1 = analyzeCategoryDAO.create();
                analyzeCat1.setName("Analyse PC");
                analyzeCategoryDAO.update(analyzeCat1);
                AnalyzeCategory analyzeCat2 = analyzeCategoryDAO.create();
                analyzeCat2.setName("4A Bactério");
                analyzeCategoryDAO.update(analyzeCat2);
                AnalyzeCategory analyzeCat3 = analyzeCategoryDAO.create();
                analyzeCat3.setName("4B 4C Bactério");
                analyzeCategoryDAO.update(analyzeCat3);
                AnalyzeCategory analyzeCat4 = analyzeCategoryDAO.create();
                analyzeCat4.setName("Pesti");
                analyzeCategoryDAO.update(analyzeCat4);
                AnalyzeCategory analyzeCat5 = analyzeCategoryDAO.create();
                analyzeCat5.setName("Métaux");
                analyzeCategoryDAO.update(analyzeCat5);

                if (log.isInfoEnabled()) {
                    log.info("Creating category " + analyzeCat1.getName());
                    log.info("Creating category " + analyzeCat2.getName());
                    log.info("Creating category " + analyzeCat3.getName());
                    log.info("Creating category " + analyzeCat4.getName());
                    log.info("Creating category " + analyzeCat5.getName());
                }
                transaction.commitTransaction();
            }

        } catch (TopiaException ex) {
            throw new SgqBusinessException("Can't init database", ex);
        } finally {
            if (transaction != null) {
                try {
                    transaction.closeContext();
                } catch (TopiaException ex) {
                    throw new SgqBusinessException("Can't init database", ex);
                }
            }
        }
    }
}
