/*
 * Decompiled with CFR 0.152.
 */
package com.helger.text;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.debug.GlobalDebug;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.text.AbstractHasText;
import com.helger.text.IMultilingualText;
import com.helger.text.locale.LocaleHelper;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadOnlyMapBasedMultilingualText
extends AbstractHasText
implements IMultilingualText,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractReadOnlyMapBasedMultilingualText.class);
    private static final AtomicBoolean CONSISTENCY_CHECK_ENABED = new AtomicBoolean(GlobalDebug.isDebugMode());
    private final ICommonsOrderedMap<Locale, String> m_aTexts;

    protected AbstractReadOnlyMapBasedMultilingualText() {
        this((ICommonsOrderedMap<Locale, String>)new CommonsLinkedHashMap());
    }

    protected AbstractReadOnlyMapBasedMultilingualText(@NonNull ICommonsOrderedMap<Locale, String> iCommonsOrderedMap) {
        this.m_aTexts = (ICommonsOrderedMap)ValueEnforcer.notNull(iCommonsOrderedMap, (String)"MapToUse");
    }

    public static void setPerformConsistencyChecks(boolean bl) {
        CONSISTENCY_CHECK_ENABED.set(bl);
    }

    public static boolean isPerformConsistencyChecks() {
        return CONSISTENCY_CHECK_ENABED.get();
    }

    private static void _performConsistencyChecks(@NonNull String string) {
        if (string.contains("\\n")) {
            LOGGER.warn("Passed string contains a masked newline - replace with an inline one:\n" + string);
        }
        if (string.contains("{0}")) {
            if (RegExHelper.stringMatchesPattern((String)"^'[^'].*", (String)string)) {
                throw new IllegalArgumentException("The passed string seems to start with unclosed single quotes: " + string);
            }
            if (RegExHelper.stringMatchesPattern((String)".*[^']'[^'].*", (String)string)) {
                throw new IllegalArgumentException("The passed string seems to contain unclosed single quotes: " + string);
            }
        } else if (RegExHelper.stringMatchesPattern((String)".*''.*", (String)string)) {
            throw new IllegalArgumentException("The passed string seems to contain 2 single quotes: " + string);
        }
    }

    protected final void internalAddText( @NonNull Map.Entry<Locale, String> entry) {
        this.internalAddText(entry.getKey(), entry.getValue());
    }

    protected final void internalAddText(@NonNull Locale locale, @Nullable String string) {
        ValueEnforcer.notNull((Object)locale, (String)"ContentLocale");
        if (this.m_aTexts.containsKey((Object)locale)) {
            throw new IllegalArgumentException("Locale '" + String.valueOf(locale) + "' already contained: " + this.toString());
        }
        this.internalSetText(locale, string);
    }

    protected final void internalSetText(@NonNull Locale locale, @Nullable String string) {
        if (string != null && CONSISTENCY_CHECK_ENABED.get()) {
            AbstractReadOnlyMapBasedMultilingualText._performConsistencyChecks(string);
        }
        this.m_aTexts.put((Object)locale, (Object)string);
    }

    @Override
    protected final @Nullable String internalGetText(@NonNull Locale locale) {
        return (String)this.m_aTexts.get((Object)locale);
    }

    @Override
    protected final @Nullable Locale internalGetLocaleToUseWithFallback(@NonNull Locale locale) {
        return LocaleHelper.getLocaleToUseOrNull(locale, this.m_aTexts.keySet());
    }

    @Override
    public final boolean containsLocaleWithFallback(@Nullable Locale locale) {
        if (locale != null) {
            for (Locale locale2 : LocaleHelper.getCalculatedLocaleListForResolving(locale)) {
                if (!this.m_aTexts.containsKey((Object)locale2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @ReturnsMutableObject
    public final @NonNull ICommonsOrderedMap<Locale, String> texts() {
        return this.m_aTexts;
    }

    @OverridingMethodsMustInvokeSuper
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractReadOnlyMapBasedMultilingualText abstractReadOnlyMapBasedMultilingualText = (AbstractReadOnlyMapBasedMultilingualText)object;
        return this.m_aTexts.equals(abstractReadOnlyMapBasedMultilingualText.m_aTexts);
    }

    @OverridingMethodsMustInvokeSuper
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator((Object)this);
        for (Map.Entry entry : this.m_aTexts.entrySet()) {
            hashCodeGenerator.append((Object)((Locale)entry.getKey()).toString()).append(entry.getValue());
        }
        return hashCodeGenerator.getHashCode();
    }

    @OverridingMethodsMustInvokeSuper
    public String toString() {
        return new ToStringGenerator((Object)this).append("Texts", this.m_aTexts).getToString();
    }
}

