/*
 * Decompiled with CFR 0.152.
 */
package com.helger.datetime.web;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.datetime.format.PDTFormatter;
import com.helger.datetime.format.PDTFromString;
import com.helger.datetime.helper.PDTFactory;
import com.helger.datetime.helper.PDTMask;
import com.helger.datetime.rt.OffsetDate;
import com.helger.datetime.xml.XMLOffsetDate;
import com.helger.datetime.xml.XMLOffsetDateTime;
import com.helger.datetime.xml.XMLOffsetTime;
import com.helger.datetime.zone.PDTConfig;
import com.helger.datetime.zone.PDTZoneID;
import com.helger.datetime.zone.WithZoneId;
import com.helger.typeconvert.impl.TypeConverter;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Locale;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class PDTWebDateHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(PDTWebDateHelper.class);
    private static final String ZONE_PATTERN1 = "XXX";
    private static final String ZONE_PATTERN2 = "XX";
    private static final String FORMAT_RFC822 = "EEE, dd MMM uuuu HH:mm:ss 'GMT'";
    private static final String FORMAT_W3C = "uuuu-MM-dd'T'HH:mm:ssXXX";
    private static final PDTMask<?>[] RFC822_MASKS = new PDTMask[]{PDTMask.zonedDateTime("EEE, dd MMM uuuu HH:mm:ss 'GMT'"), PDTMask.zonedDateTime("EEE, dd MMM uuuu HH:mm:ss XX"), PDTMask.localDateTime("EEE, dd MMM uuuu HH:mm:ss"), PDTMask.localDateTime("EEE, dd MMM uu HH:mm:ss"), PDTMask.localDateTime("EEE, dd MMM uuuu HH:mm"), PDTMask.localDateTime("EEE, dd MMM uu HH:mm"), PDTMask.localDateTime("dd MMM uuuu HH:mm:ss"), PDTMask.localDateTime("dd MMM uu HH:mm:ss"), PDTMask.localDateTime("dd MMM uuuu HH:mm"), PDTMask.localDateTime("dd MMM uu HH:mm")};
    private static final PDTMask<?>[] W3CDATETIME_MASKS = new PDTMask[]{PDTMask.offsetDateTime("uuuu-MM-dd'T'HH:mm:ss.SSSXXX"), PDTMask.offsetDateTime("uuuu-MM-dd'T'HH:mm:ss.SSSXX"), PDTMask.offsetDateTime("uuuu-MM-dd't'HH:mm:ss.SSSXXX"), PDTMask.offsetDateTime("uuuu-MM-dd't'HH:mm:ss.SSSXX"), PDTMask.localDateTime("uuuu-MM-dd'T'HH:mm:ss.SSS"), PDTMask.localDateTime("uuuu-MM-dd't'HH:mm:ss.SSS"), PDTMask.offsetDateTime("uuuu-MM-dd'T'HH:mm:ssXXX"), PDTMask.offsetDateTime("uuuu-MM-dd'T'HH:mm:ssXX"), PDTMask.offsetDateTime("uuuu-MM-dd't'HH:mm:ssXXX"), PDTMask.offsetDateTime("uuuu-MM-dd't'HH:mm:ssXX"), PDTMask.localDateTime("uuuu-MM-dd'T'HH:mm:ss"), PDTMask.localDateTime("uuuu-MM-dd't'HH:mm:ss"), PDTMask.offsetDateTime("uuuu-MM-dd'T'HH:mmXXX"), PDTMask.offsetDateTime("uuuu-MM-dd'T'HH:mmXX"), PDTMask.offsetDateTime("uuuu-MM-dd't'HH:mmXXX"), PDTMask.offsetDateTime("uuuu-MM-dd't'HH:mmXX"), PDTMask.localDateTime("uuuu-MM-dd'T'HH:mm"), PDTMask.localDateTime("uuuu-MM-dd't'HH:mm"), PDTMask.localDateTime("uuuu-MM'T'HH:mm"), PDTMask.localDateTime("uuuu'T'HH:mm"), PDTMask.localDate("uuuu-MM-dd"), PDTMask.yearMonth("uuuu-MM"), PDTMask.year("uuuu")};
    private static final Locale LOCALE_TO_USE = Locale.US;
    private static final PDTWebDateHelper INSTANCE = new PDTWebDateHelper();
    public static final DateTimeFormatter XSD_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendFraction(ChronoField.MILLI_OF_SECOND, 0, 9, true).optionalEnd().optionalStart().appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(Locale.getDefault(Locale.Category.FORMAT)).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter XSD_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).optionalStart().appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(Locale.getDefault(Locale.Category.FORMAT)).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);
    public static final DateTimeFormatter XSD_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').append(XSD_TIME).toFormatter(Locale.getDefault(Locale.Category.FORMAT)).withResolverStyle(ResolverStyle.STRICT).withChronology(IsoChronology.INSTANCE);

    private PDTWebDateHelper() {
    }

    public static @Nullable OffsetDateTime parseOffsetDateTimeUsingMask(@NonNull PDTMask<?>[] pDTMaskArray, @NonNull @Nonempty String string) {
        for (PDTMask<?> pDTMask : pDTMaskArray) {
            DateTimeFormatter dateTimeFormatter = PDTFormatter.getForPattern(pDTMask.getPattern(), LOCALE_TO_USE);
            try {
                Temporal temporal = (Temporal)dateTimeFormatter.parse((CharSequence)string, pDTMask.getQuery());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Parsed '" + string + "' with '" + pDTMask.getPattern() + "' to " + temporal.getClass().getName());
                }
                return (OffsetDateTime)TypeConverter.convert((Object)temporal, OffsetDateTime.class);
            }
            catch (DateTimeParseException dateTimeParseException) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Failed to parse '" + string + "' with '" + pDTMask.getPattern() + "': " + dateTimeParseException.getMessage());
            }
        }
        return null;
    }

    public static @Nullable ZonedDateTime parseZonedDateTimeUsingMask(@NonNull PDTMask<?>[] pDTMaskArray, @NonNull @Nonempty String string, @Nullable ZoneId zoneId) {
        for (PDTMask<?> pDTMask : pDTMaskArray) {
            DateTimeFormatter dateTimeFormatter = PDTFormatter.getForPattern(pDTMask.getPattern(), LOCALE_TO_USE);
            if (zoneId != null) {
                dateTimeFormatter = dateTimeFormatter.withZone(zoneId);
            }
            try {
                Temporal temporal = (Temporal)dateTimeFormatter.parse((CharSequence)string, pDTMask.getQuery());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Parsed '" + string + "' with '" + pDTMask.getPattern() + "' to " + temporal.getClass().getName());
                }
                return (ZonedDateTime)TypeConverter.convert((Object)temporal, ZonedDateTime.class);
            }
            catch (DateTimeParseException dateTimeParseException) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Failed to parse '" + string + "' with '" + pDTMask.getPattern() + "': " + dateTimeParseException.getMessage());
            }
        }
        return null;
    }

    public static @NonNull WithZoneId extractDateTimeZone(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Date");
        int n = string.length();
        for (PDTZoneID pDTZoneID : PDTZoneID.getDefaultZoneIDs()) {
            String string2 = pDTZoneID.getZoneIDString();
            if (string.endsWith(" " + string2)) {
                return new WithZoneId(string.substring(0, n - (1 + string2.length())), pDTZoneID.getZoneID());
            }
            if (!string.endsWith(string2)) continue;
            return new WithZoneId(string.substring(0, n - string2.length()), pDTZoneID.getZoneID());
        }
        return new WithZoneId(string, null);
    }

    public static @Nullable ZonedDateTime getDateTimeFromRFC822(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        WithZoneId withZoneId = PDTWebDateHelper.extractDateTimeZone(string.trim());
        return PDTWebDateHelper.parseZonedDateTimeUsingMask(RFC822_MASKS, withZoneId.getString(), withZoneId.getZoneID());
    }

    public static @Nullable OffsetDateTime getDateTimeFromW3C(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return PDTWebDateHelper.parseOffsetDateTimeUsingMask(W3CDATETIME_MASKS, string.trim());
    }

    public static @Nullable ZonedDateTime getDateTimeFromW3COrRFC822(@Nullable String string) {
        OffsetDateTime offsetDateTime = PDTWebDateHelper.getDateTimeFromW3C(string);
        if (offsetDateTime != null) {
            return offsetDateTime.toZonedDateTime();
        }
        return PDTWebDateHelper.getDateTimeFromRFC822(string);
    }

    public static @Nullable LocalDateTime getLocalDateTimeFromW3COrRFC822(@Nullable String string) {
        ZonedDateTime zonedDateTime = PDTWebDateHelper.getDateTimeFromW3COrRFC822(string);
        return zonedDateTime == null ? null : zonedDateTime.toLocalDateTime();
    }

    public static @Nullable String getAsStringRFC822(@Nullable ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        return PDTFormatter.getForPattern(FORMAT_RFC822, LOCALE_TO_USE).format(zonedDateTime);
    }

    public static @Nullable String getAsStringRFC822(@Nullable OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return null;
        }
        return PDTWebDateHelper.getAsStringRFC822(offsetDateTime.toZonedDateTime());
    }

    public static @Nullable String getAsStringRFC822(@Nullable LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return PDTWebDateHelper.getAsStringRFC822(localDateTime.atOffset(ZoneOffset.UTC));
    }

    public static @Nullable String getAsStringW3C(@Nullable ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        DateTimeFormatter dateTimeFormatter = PDTFormatter.getForPattern(FORMAT_W3C, LOCALE_TO_USE);
        return dateTimeFormatter.format(zonedDateTime);
    }

    public static @Nullable String getAsStringW3C(@Nullable OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return null;
        }
        return PDTWebDateHelper.getAsStringW3C(offsetDateTime.toZonedDateTime());
    }

    public static @Nullable String getAsStringW3C(@Nullable LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return PDTWebDateHelper.getAsStringW3C(localDateTime.atOffset(ZoneOffset.UTC));
    }

    public static @NonNull String getCurrentDateTimeAsStringRFC822() {
        ZonedDateTime zonedDateTime = ZonedDateTime.now(Clock.systemUTC()).withNano(0);
        return PDTWebDateHelper.getAsStringRFC822(zonedDateTime);
    }

    public static @NonNull String getCurrentDateTimeAsStringW3C() {
        ZonedDateTime zonedDateTime = PDTFactory.getCurrentZonedDateTime().withNano(0);
        return PDTWebDateHelper.getAsStringW3C(zonedDateTime);
    }

    public static @NonNull DateTimeFormatter getXSDFormatterDateTime(@Nullable ZoneId zoneId) {
        DateTimeFormatter dateTimeFormatter = XSD_DATE_TIME;
        if (zoneId != null) {
            dateTimeFormatter = dateTimeFormatter.withZone(zoneId);
        }
        return dateTimeFormatter;
    }

    public static @Nullable LocalDateTime getLocalDateTimeFromXSD(@Nullable String string) {
        return PDTFromString.getLocalDateTimeFromString(string, PDTWebDateHelper.getXSDFormatterDateTime(ZoneOffset.UTC));
    }

    public static @Nullable String getAsStringXSD(@Nullable LocalDateTime localDateTime) {
        return localDateTime == null ? null : PDTWebDateHelper.getXSDFormatterDateTime(PDTConfig.getDefaultZoneId()).format(localDateTime);
    }

    public static @Nullable ZonedDateTime getZonedDateTimeFromXSD(@Nullable String string) {
        return PDTWebDateHelper.getZonedDateTimeFromXSD(string, null);
    }

    public static @Nullable ZonedDateTime getZonedDateTimeFromXSD(@Nullable String string, @Nullable ZoneId zoneId) {
        return PDTFromString.getZonedDateTimeFromString(string, PDTWebDateHelper.getXSDFormatterDateTime(zoneId));
    }

    public static @Nullable String getAsStringXSD(@Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : PDTWebDateHelper.getAsStringXSD(zonedDateTime.getZone(), zonedDateTime);
    }

    public static @Nullable String getAsStringXSD(@NonNull ZoneId zoneId, @Nullable ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : PDTWebDateHelper.getXSDFormatterDateTime(zoneId).format(zonedDateTime);
    }

    public static @Nullable OffsetDateTime getOffsetDateTimeFromXSD(@Nullable String string) {
        return PDTFromString.getOffsetDateTimeFromString(string, PDTWebDateHelper.getXSDFormatterDateTime(null));
    }

    public static @Nullable String getAsStringXSD(@Nullable OffsetDateTime offsetDateTime) {
        return offsetDateTime == null ? null : PDTWebDateHelper.getXSDFormatterDateTime(null).format(offsetDateTime);
    }

    public static @Nullable XMLOffsetDateTime getXMLOffsetDateTimeFromXSD(@Nullable String string) {
        LocalDateTime localDateTime;
        XMLOffsetDateTime xMLOffsetDateTime = PDTFromString.getXMLOffsetDateTimeFromString(string, PDTWebDateHelper.getXSDFormatterDateTime(null));
        if (xMLOffsetDateTime == null && string != null && (localDateTime = PDTWebDateHelper.getLocalDateTimeFromXSD(string)) != null) {
            xMLOffsetDateTime = XMLOffsetDateTime.of(localDateTime);
        }
        return xMLOffsetDateTime;
    }

    public static @Nullable String getAsStringXSD(@Nullable XMLOffsetDateTime xMLOffsetDateTime) {
        if (xMLOffsetDateTime == null) {
            return null;
        }
        if (!xMLOffsetDateTime.hasOffset()) {
            return PDTWebDateHelper.getAsStringXSD(xMLOffsetDateTime.toLocalDateTime());
        }
        return PDTWebDateHelper.getXSDFormatterDateTime(null).format(xMLOffsetDateTime);
    }

    public static @NonNull DateTimeFormatter getXSDFormatterDate() {
        return XSD_DATE;
    }

    public static @Nullable LocalDate getLocalDateFromXSD(@Nullable String string) {
        return PDTFromString.getLocalDateFromString(string, PDTWebDateHelper.getXSDFormatterDate());
    }

    public static @Nullable String getAsStringXSD(@Nullable LocalDate localDate) {
        return localDate == null ? null : PDTWebDateHelper.getXSDFormatterDate().format(localDate);
    }

    public static @Nullable OffsetDate getOffsetDateFromXSD(@Nullable String string) {
        return PDTFromString.getOffsetDateFromString(string, PDTWebDateHelper.getXSDFormatterDate());
    }

    public static @Nullable String getAsStringXSD(@Nullable OffsetDate offsetDate) {
        return offsetDate == null ? null : PDTWebDateHelper.getXSDFormatterDate().format(offsetDate);
    }

    public static @Nullable XMLOffsetDate getXMLOffsetDateFromXSD(@Nullable String string) {
        LocalDate localDate;
        XMLOffsetDate xMLOffsetDate = PDTFromString.getXMLOffsetDateFromString(string, PDTWebDateHelper.getXSDFormatterDate());
        if (xMLOffsetDate == null && string != null && (localDate = PDTWebDateHelper.getLocalDateFromXSD(string)) != null) {
            xMLOffsetDate = XMLOffsetDate.of(localDate);
        }
        return xMLOffsetDate;
    }

    public static @Nullable String getAsStringXSD(@Nullable XMLOffsetDate xMLOffsetDate) {
        if (xMLOffsetDate == null) {
            return null;
        }
        if (!xMLOffsetDate.hasOffset()) {
            return PDTWebDateHelper.getAsStringXSD(xMLOffsetDate.toLocalDate());
        }
        return PDTWebDateHelper.getXSDFormatterDate().format(xMLOffsetDate);
    }

    public static @NonNull DateTimeFormatter getXSDFormatterTime() {
        return XSD_TIME;
    }

    public static @Nullable LocalTime getLocalTimeFromXSD(@Nullable String string) {
        return PDTFromString.getLocalTimeFromString(string, PDTWebDateHelper.getXSDFormatterTime());
    }

    public static @Nullable String getAsStringXSD(@Nullable LocalTime localTime) {
        return localTime == null ? null : PDTWebDateHelper.getXSDFormatterTime().format(localTime);
    }

    public static @Nullable OffsetTime getOffsetTimeFromXSD(@Nullable String string) {
        return PDTFromString.getOffsetTimeFromString(string, PDTWebDateHelper.getXSDFormatterTime());
    }

    public static @Nullable String getAsStringXSD(@Nullable OffsetTime offsetTime) {
        return offsetTime == null ? null : PDTWebDateHelper.getXSDFormatterTime().format(offsetTime);
    }

    public static @Nullable XMLOffsetTime getXMLOffsetTimeFromXSD(@Nullable String string) {
        LocalTime localTime;
        XMLOffsetTime xMLOffsetTime = PDTFromString.getXMLOffsetTimeFromString(string, PDTWebDateHelper.getXSDFormatterTime());
        if (xMLOffsetTime == null && string != null && (localTime = PDTWebDateHelper.getLocalTimeFromXSD(string)) != null) {
            xMLOffsetTime = XMLOffsetTime.of(localTime);
        }
        return xMLOffsetTime;
    }

    public static @Nullable String getAsStringXSD(@Nullable XMLOffsetTime xMLOffsetTime) {
        if (xMLOffsetTime == null) {
            return null;
        }
        if (!xMLOffsetTime.hasOffset()) {
            return PDTWebDateHelper.getAsStringXSD(xMLOffsetTime.toLocalTime());
        }
        return PDTWebDateHelper.getXSDFormatterTime().format(xMLOffsetTime);
    }
}

