/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.iterator;

import com.helger.annotation.Nonnegative;
import com.helger.base.array.bytes.ByteArrayWrapper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import java.util.NoSuchElementException;
import org.jspecify.annotations.NonNull;

public final class ArrayIteratorByte {
    public static final boolean DEFAULT_COPY_NEEDED = true;
    private final ByteArrayWrapper m_aBytes;
    private int m_nIndex = 0;

    public ArrayIteratorByte(byte ... byArray) {
        this(byArray, 0, byArray.length, true);
    }

    public ArrayIteratorByte(byte @NonNull [] byArray, boolean bl) {
        this(byArray, 0, byArray.length, bl);
    }

    public ArrayIteratorByte(byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this(byArray, n, n2, true);
    }

    public ArrayIteratorByte(byte @NonNull [] byArray, @Nonnegative int n, @Nonnegative int n2, boolean bl) {
        ValueEnforcer.isArrayOfsLen((byte[])byArray, (int)n, (int)n2);
        this.m_aBytes = new ByteArrayWrapper(byArray, n, n2, bl);
    }

    public boolean hasNext() {
        return this.m_nIndex < this.m_aBytes.size();
    }

    public byte next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.m_aBytes.bytes()[this.m_nIndex++];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ArrayIteratorByte arrayIteratorByte = (ArrayIteratorByte)object;
        return this.m_aBytes.equals((Object)arrayIteratorByte.m_aBytes) && this.m_nIndex == arrayIteratorByte.m_nIndex;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aBytes).append(this.m_nIndex).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Bytes", (Object)this.m_aBytes).append("Index", this.m_nIndex).getToString();
    }
}

