/*
 * Decompiled with CFR 0.152.
 */
package com.helger.collection.base;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.base.IIterableIterator;
import java.util.Iterator;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class MapperIterator<SRCTYPE, ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private final Iterator<? extends SRCTYPE> m_aBaseIter;
    private final Function<? super SRCTYPE, ? extends ELEMENTTYPE> m_aConverter;

    public MapperIterator(@NonNull IIterableIterator<? extends SRCTYPE> iIterableIterator, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this(iIterableIterator.iterator(), function);
    }

    public MapperIterator(@NonNull Iterable<? extends SRCTYPE> iterable, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this(iterable.iterator(), function);
    }

    public MapperIterator(@NonNull Iterator<? extends SRCTYPE> iterator, @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        this.m_aBaseIter = (Iterator)ValueEnforcer.notNull(iterator, (String)"BaseIterator");
        this.m_aConverter = (Function)ValueEnforcer.notNull(function, (String)"Filter");
    }

    public @NonNull Function<? super SRCTYPE, ? extends ELEMENTTYPE> getConverter() {
        return this.m_aConverter;
    }

    @Override
    public boolean hasNext() {
        return this.m_aBaseIter.hasNext();
    }

    @Override
    public @Nullable ELEMENTTYPE next() {
        SRCTYPE SRCTYPE = this.m_aBaseIter.next();
        return this.m_aConverter.apply(SRCTYPE);
    }

    @Override
    public void remove() {
        this.m_aBaseIter.remove();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BaseIter", this.m_aBaseIter).append("Converter", this.m_aConverter).getToString();
    }
}

