/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.FilesOnlyFileFilter;
import com.googlecode.t7mp.SetupUtil;
import com.googlecode.t7mp.TomcatSetupException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;

public class TomcatConfigFilesSetup {
    private final File catalinaBaseDir;
    private final Log log;
    private final SetupUtil setupUtil;

    public TomcatConfigFilesSetup(File catalinaBaseDir, Log log, SetupUtil setupUtil) {
        this.catalinaBaseDir = catalinaBaseDir;
        this.log = log;
        this.setupUtil = setupUtil;
    }

    public TomcatConfigFilesSetup copyDefaultConfig() {
        this.copyConfigResource("catalina.policy");
        this.copyConfigResource("context.xml");
        this.copyConfigResource("logging.properties");
        this.copyConfigResource("server.xml");
        this.copyConfigResource("tomcat-users.xml");
        this.copyConfigResource("web.xml");
        return this;
    }

    protected void copyConfigResource(String name) {
        this.log.debug((CharSequence)("Copy default config file '" + name + "' to " + this.catalinaBaseDir.getAbsolutePath() + "/conf/" + name));
        try {
            this.setupUtil.copy(this.getClass().getResourceAsStream("conf/" + name), new FileOutputStream(new File(this.catalinaBaseDir, "/conf/" + name)));
        }
        catch (FileNotFoundException e) {
            throw new TomcatSetupException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TomcatSetupException(e.getMessage(), e);
        }
    }

    public void copyUserConfigs(File userConfigDir) {
        if (userConfigDir == null) {
            this.log.info((CharSequence)"No directory for userConfigFiles configured.");
            return;
        }
        if (!userConfigDir.exists() || !userConfigDir.isDirectory()) {
            this.log.warn((CharSequence)("The configured Directory for configuration files does not exist. " + userConfigDir.getAbsolutePath()));
            this.log.warn((CharSequence)"Ignoring user configuration.");
        }
        if (userConfigDir.exists() && userConfigDir.isDirectory()) {
            File[] files;
            for (File configFile : files = userConfigDir.listFiles(new FilesOnlyFileFilter())) {
                try {
                    this.log.debug((CharSequence)("Copy provided config file '" + configFile.getName() + "' to " + this.catalinaBaseDir.getAbsolutePath() + "/conf/" + configFile.getName()));
                    this.setupUtil.copy(new FileInputStream(configFile), new FileOutputStream(new File(this.catalinaBaseDir, "/conf/" + configFile.getName())));
                }
                catch (FileNotFoundException e) {
                    throw new TomcatSetupException(e.getMessage(), e);
                }
                catch (IOException e) {
                    throw new TomcatSetupException(e.getMessage(), e);
                }
            }
        }
    }
}

