/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.AbstractT7Mojo;
import com.googlecode.t7mp.DefaultTomcatSetup;
import com.googlecode.t7mp.PreConditions;
import com.googlecode.t7mp.TomcatSetup;
import com.googlecode.t7mp.TomcatShutdownHook;
import org.apache.catalina.startup.Bootstrap;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class RunMojo
extends AbstractT7Mojo {
    protected Bootstrap bootstrap;
    protected TomcatSetup tomcatSetup;

    public void execute() throws MojoExecutionException, MojoFailureException {
        PreConditions.checkConfiguredTomcatVersion(this.getLog(), this.tomcatVersion);
        this.tomcatSetup = this.getTomcatSetup();
        this.tomcatSetup.buildTomcat();
        System.setProperty("catalina.home", this.catalinaBase.getAbsolutePath());
        System.setProperty("catalina.base", this.catalinaBase.getAbsolutePath());
        this.bootstrap = this.getBootstrap();
        this.getLog().info((CharSequence)"Starting Tomcat ...");
        try {
            this.bootstrap.init();
            if (this.tomcatSetAwait) {
                Runtime.getRuntime().addShutdownHook(new TomcatShutdownHook(this.bootstrap));
                this.bootstrap.setAwait(this.tomcatSetAwait);
                this.bootstrap.start();
            } else {
                this.bootstrap.start();
                this.getPluginContext().put(T7_BOOTSTRAP_CONTEXT_ID, this.bootstrap);
                Runtime.getRuntime().addShutdownHook(new TomcatShutdownHook(this.bootstrap));
                this.getLog().info((CharSequence)"Tomcat started");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected TomcatSetup getTomcatSetup() {
        return new DefaultTomcatSetup(this);
    }

    protected Bootstrap getBootstrap() {
        return new Bootstrap();
    }
}

