/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.t7mp;

import com.googlecode.t7mp.AbstractT7Mojo;
import com.googlecode.t7mp.CommonsSetupUtil;
import com.googlecode.t7mp.JarArtifact;
import com.googlecode.t7mp.MyArtifactResolver;
import com.googlecode.t7mp.SetupUtil;
import com.googlecode.t7mp.TomcatArtifactDescriptorReader;
import com.googlecode.t7mp.TomcatArtifactDispatcher;
import com.googlecode.t7mp.TomcatConfigFilesSetup;
import com.googlecode.t7mp.TomcatDirectorySetup;
import com.googlecode.t7mp.TomcatSetup;
import com.googlecode.t7mp.TomcatSetupException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public abstract class AbstractTomcatSetup
implements TomcatSetup {
    protected AbstractT7Mojo t7Mojo = null;
    protected SetupUtil setupUtil = new CommonsSetupUtil();
    protected Log log;
    protected TomcatDirectorySetup directorySetup;
    protected TomcatConfigFilesSetup configFilesSetup;
    protected TomcatArtifactDescriptorReader artifactDescriptorReader;
    protected MyArtifactResolver myArtifactResolver;
    protected TomcatArtifactDispatcher libDispatcher;

    public AbstractTomcatSetup(AbstractT7Mojo t7Mojo) {
        this.t7Mojo = t7Mojo;
    }

    protected abstract void configure() throws TomcatSetupException;

    protected void validateConfiguration() throws TomcatSetupException {
        TomcatSetupException.notNull((Object)this.t7Mojo, "t7Mojo");
        TomcatSetupException.notNull(this.log, "log");
        TomcatSetupException.notNull(this.setupUtil, "setupUtil");
        TomcatSetupException.notNull(this.directorySetup, "directorySetup");
        TomcatSetupException.notNull(this.configFilesSetup, "configFilesSetup");
        TomcatSetupException.notNull(this.artifactDescriptorReader, "artifactDescriptorReader");
        TomcatSetupException.notNull(this.libDispatcher, "libDispatcher");
    }

    @Override
    public void buildTomcat() throws MojoExecutionException {
        try {
            this.configure();
            this.validateConfiguration();
            this.directorySetup.createTomcatDirectories();
            this.configFilesSetup.copyDefaultConfig();
            this.buildCatalinaPropertiesFile();
            this.configFilesSetup.copyUserConfigs(this.t7Mojo.tomcatConfigDirectory);
            List<JarArtifact> tomcatLibs = this.artifactDescriptorReader.getJarArtifacts(this.t7Mojo.tomcatVersion);
            this.libDispatcher.resolveArtifacts(tomcatLibs).copyTo("lib");
            this.libDispatcher.clear();
            this.libDispatcher.resolveArtifacts(this.t7Mojo.libs).copyTo("lib");
            this.libDispatcher.clear();
            this.libDispatcher.resolveArtifacts(this.t7Mojo.webapps).copyTo("webapps");
            this.copyWebapp();
        }
        catch (TomcatSetupException e) {
            this.t7Mojo.getLog().error((CharSequence)"Error setting up tomcat.");
            this.t7Mojo.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected void buildCatalinaPropertiesFile() {
        try {
            Velocity.setProperty((String)"runtime.log.logsystem", (Object)new LogNothingLogChute());
            Velocity.setProperty((String)"resource.loader", (Object)"class");
            Velocity.setProperty((String)"class.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
            Velocity.setProperty((String)"class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            Velocity.init();
            Template template = Velocity.getTemplate((String)"com/googlecode/t7mp/conf/catalina.properties");
            VelocityContext context = new VelocityContext();
            context.put("tomcatHttpPort", (Object)(this.t7Mojo.getTomcatHttpPort() + ""));
            context.put("tomcatShutdownPort", (Object)(this.t7Mojo.getTomcatShutdownPort() + ""));
            context.put("tomcatShutdownCommand", (Object)this.t7Mojo.getTomcatShutdownCommand());
            FileWriter writer = new FileWriter(new File(this.t7Mojo.catalinaBase, "/conf/catalina.properties"));
            template.merge((Context)context, (Writer)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new TomcatSetupException(e.getMessage(), e);
        }
    }

    protected void copyWebapp() throws TomcatSetupException {
        if (!this.t7Mojo.isWebProject()) {
            return;
        }
        if (this.t7Mojo.webappOutputDirectory == null || !this.t7Mojo.webappOutputDirectory.exists()) {
            return;
        }
        try {
            this.setupUtil.copyDirectory(this.t7Mojo.webappOutputDirectory, new File(this.t7Mojo.catalinaBase, "/webapps/" + this.t7Mojo.webappOutputDirectory.getName()));
        }
        catch (IOException e) {
            throw new TomcatSetupException(e.getMessage(), e);
        }
    }

    static class LogNothingLogChute
    implements LogChute {
        LogNothingLogChute() {
        }

        public void init(RuntimeServices rs) throws Exception {
        }

        public void log(int level, String message) {
        }

        public void log(int level, String message, Throwable t) {
        }

        public boolean isLevelEnabled(int level) {
            return false;
        }
    }
}

